/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

package com.salelder;

import java.awt.event.MouseEvent;

import javax.swing.event.MouseInputAdapter;

public class PreviewMouse extends MouseInputAdapter {
	PreviewPanel preview;
	public PreviewMouse(PreviewPanel p) {preview = p;}
	
	private int fromX=0, fromY=0; // move quad or vertex relative to these coordinates
	
	public void mouseClicked(MouseEvent e) {
		//preview.requestFocusInWindow();
		//System.out.println("Registered click.");
	}
	
	public void mousePressed(MouseEvent e) {
		fromX = e.getX();
		fromY = e.getY();
	}
	
	public void mouseMoved(MouseEvent e) {
		//System.out.println("Registered move.");
		preview.updateSelected(e.getX(), e.getY());
	}
	
	public void mouseDragged(MouseEvent e) {
		if (preview.contains(e.getX(), e.getY())) {
			preview.quad.moveSelectedBy(e.getX()-fromX, e.getY()-fromY);
			fromX = e.getX();
			fromY = e.getY();
			preview.quad.boundWithin(preview.getVideoWidth(), preview.getVideoHeight());
		}
	}
}
