/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

package com.salelder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.plaf.metal.MetalIconFactory;

import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;

public class LoadImageListener implements ActionListener {
	private PreviewPanel preview;
	private OptionsPanel options;
	private License license;
	private DemoImage[] demoImages;
	
	public LoadImageListener(PreviewPanel p, OptionsPanel o, License l) {
		preview = p; options=o; license = l;
	
		// refresh resources folder in Eclipse after changes
		String[] demoFilenames = {"dog.jpg", "liberty.jpg", "monalisa.jpg", "tajmahal.jpg"};
		String[] demoDigests = {"9cf06be505cba7b5f792da7285aabed2", "ccd71d9538dfe1e7128ab26cf0ad51bf", "95b1b31e75690d391e194f7171427fd4", "54acfcf6e7227b4fd2481d4375f98adb"};
		String[] demoNames = {"Dog", "Statue of Liberty", "Mona Lisa", "Taj Mahal"};
		demoImages = new DemoImage[demoFilenames.length];
		for (int k =0; k < demoImages.length; ++k) {
			demoImages[k] = new DemoImage(demoFilenames[k], demoDigests[k], demoNames[k]);
		}
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		if (license.isActive()) openAnyFile();
		else openDemoFile();
		
	}
	
	public void openDemoFile() {
		/* Allow the user to choose from a list of demo images. */
		DemoImage selected = 
				(DemoImage)JOptionPane.showInputDialog(options,
						"Select a reference image from the list provided.\nIn the paid version, you can add your own images.",
						"Select reference image", JOptionPane.QUESTION_MESSAGE,
				MetalIconFactory.getFileChooserListViewIcon(), demoImages, demoImages[0]);
		preview.setReferenceImageWithoutFile(selected.getMBFImage());
	}
	
	public void openAnyFile() {
		/* Prompt the user to choose a file from their computer and attempt to set it as the reference image. */
		if (options.fileChooser.showOpenDialog(options) == JFileChooser.APPROVE_OPTION) {
			File selectedFile = options.fileChooser.getSelectedFile();
			try {
				preview.setReference(selectedFile);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				JOptionPane.showMessageDialog(options,
						"Couldn't open file.\nTry closing other applications which may be using it.",
						"File error", JOptionPane.ERROR_MESSAGE);
				return;
			}
		}
		else { // no image selected
			
		}
	}
	
}
