/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

package com.salelder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Arrays;

import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;

public class DemoImage {
	/* An image which can be selected in the demo version.
	 * If the file is changed inside the jar, replace with a placeholder. */
	
	/* Note: no longer used, since it's now free and open-source. */
	private MBFImage image;
	private String name;
	public DemoImage(String filename, String md5sum, String name) {
		/* Create a DemoImage from filename and expected md5 digest, as a hex string,
		 * for example what you get from copying the output of md5sum filename.
		 * If actual digest doesn't match, then store a placeholder.
		 * name is used for toString() */
		this.name = name;
		URL imgURL = getClass().getClassLoader().getResource(filename);
		//System.out.println(imgURL.getPath());
		try {
			//FileInputStream f = new FileInputStream(imgURL.getFile());
			InputStream f = getClass().getClassLoader().getResourceAsStream(filename);
			byte[] contents = f.readAllBytes();
			f.close();
				
			byte[] digest = MessageDigest.getInstance("MD5").digest(contents);
			if (!Arrays.equals(digest, License.hexStringToBytes(md5sum))) {
				// file changed
				throw new Exception();
			}
			
			image = ImageUtilities.readMBF(imgURL);
			//throw new Exception();
			
		} catch (Exception e) {
			System.out.println(e.getMessage());
			image = new MBFImage(200,200);
		}
	}
	
	public String toString() {
		return name;
	}
	public MBFImage getMBFImage() {
		return image;
	}

}
