/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

package com.salelder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.openimaj.video.capture.Device;

public class PreviewController implements ChangeListener, ActionListener, ItemListener {
	private PreviewPanel preview;
	private OptionsPanel options;
	
	public PreviewController(PreviewPanel p, OptionsPanel o) {
		preview = p;
		options = o;
	}

	@Override
	public void stateChanged(ChangeEvent arg0) {
		// one of the sliders changed
		preview.setOpacity(options.getOpacity());
		preview.setBrightness(options.getBrightness());
		preview.setContrast(options.getContrast());
		preview.setScale(options.getScale());
		preview.setPanX(options.getPanX());
		preview.setPanY(options.getPanY());
		preview.setColorTemp(options.getColorTemp());
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		// pressed toggle view button
		preview.toggleView();
	}
	
	public void toggleOpacity() {
		if (!preview.hasReference()) return;
		if (preview.getOpacity() == 1f) {preview.setOpacity(0f);}
		else preview.setOpacity(1f);
	}

	@Override
	public void itemStateChanged(ItemEvent arg0) {
		if (arg0 != null && arg0.getStateChange() != ItemEvent.SELECTED) {return;}
		//System.out.println("Item changed");
		Device d = options.getWebcam();
		//System.out.println(d);
		preview.setWebcam(d, options.getVideoWidth(), options.getVideoHeight());
	}

}
