/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

package com.salelder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

public class LicenseDialog implements ActionListener {
	private App app;
	private License license;
	
	public LicenseDialog(App a, License l) {
		/* Class to guide user through product activation. */
		app=a; license=l;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		if (license.isActive()) {
			JOptionPane.showMessageDialog(app,
					"This copy of the software has already been activated.",
					"Active", JOptionPane.INFORMATION_MESSAGE);
			return;
		}
		String key = JOptionPane.showInputDialog(app,
				"Please enter your license key:", "Registration", JOptionPane.QUESTION_MESSAGE);
		if (key != null) {
			license.setLicense(key);
			int status = license.activate();
			
			if (status == License.CONNECTION_ERROR) {
				JOptionPane.showMessageDialog(app,
						"Could not connect to activation server.\nPlease check your Internet connection and try again.",
						"Connection error", JOptionPane.ERROR_MESSAGE);
			} else if (status == License.LICENSE_NOT_RECOGNIZED) {
				JOptionPane.showMessageDialog(app,
						"License not recognized. Please check that you have entered the"
						+ "\nkey exactly as it was provided when you purchased the software.",
						"License error", JOptionPane.ERROR_MESSAGE);
			} else if (status == License.MAX_DEVICES_REGISTERED) {
				JOptionPane.showMessageDialog(app,
						"Maximum devices already registered with this license key.",
						"License error", JOptionPane.ERROR_MESSAGE);
			} else if (status == License.UNEXPECTED_RESPONSE || !license.isActive()) {
				JOptionPane.showMessageDialog(app,
						"Activation server returned an unexpected response.\nPlease contact customer support.",
						"Activation error", JOptionPane.ERROR_MESSAGE);
			} else {
				JOptionPane.showMessageDialog(app,
						"You have successfully activated your copy of the software!",
						"Success", JOptionPane.INFORMATION_MESSAGE);
			}
		}
		app.notifyLicenseChanged();
	}

}
