/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

package com.salelder;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileListener implements ActionListener {
	public static int OPEN_DIALOG = 0;
	public static int SAVE_DIALOG = 1;
	public static int SAVE_AS_DIALOG = 2;
	
	private FileNameExtensionFilter filter;
	private JFileChooser fileChooser;
	private Component uiParent;
	private int dialogType;
	private FileUser app;
	
	public FileListener(FileNameExtensionFilter ext, JFileChooser jfc, Component p,
			int dt, FileUser a) {
		filter = ext; fileChooser = jfc; uiParent=p; dialogType = dt; app = a;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		if (dialogType == OPEN_DIALOG) {
			/* If file selected, call the FileUser's openFile. */
			fileChooser.setFileFilter(filter);
			if (fileChooser.showOpenDialog(uiParent) == JFileChooser.APPROVE_OPTION) {
				app.openFile(fileChooser.getSelectedFile());
			}
			else return;
		}
		else if (dialogType == SAVE_DIALOG && app.hasActiveFile()) {
			app.saveFile();
		}
		else { // save as
			fileChooser.setFileFilter(filter);
			if (fileChooser.showSaveDialog(uiParent) == JFileChooser.APPROVE_OPTION) {
				File selected = fileChooser.getSelectedFile();
				if (fileChooser.getFileFilter() == filter &&
						!filter.accept(selected)) { // force file extension
					String newName = selected.getAbsolutePath() + "." + filter.getExtensions()[0];
					selected = new File(newName);
				}
				app.saveFile(selected);
			}
		}
	}

}
