/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

package com.salelder;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ConfigFile {
	private Quad quad;
	private File refFile;
	private float brightness, contrast, scale, panX, panY;
	private double colorTemp;
	private int videoWidth, videoHeight;
	
	public ConfigFile(Quad q, File r, float brightness, float contrast, float scale, float panX, float panY,
			double temp, int width, int height) {
		quad = q;
		refFile = r;
		this.brightness=brightness;
		this.contrast=contrast;
		this.scale=scale;
		this.panX=panX;
		this.panY=panY;
		this.colorTemp=temp;
		this.videoWidth=width;
		this.videoHeight=height;
	}
	
	public ConfigFile(File f) throws IOException {
		loadJSON(f);
	}
	
	public void loadJSON(File f) throws IOException {
		FileReader reader = new FileReader(f);
		JSONTokener tokener = new JSONTokener(reader);
		JSONObject obj = new JSONObject(tokener);
		JSONArray xs = obj.getJSONArray("xs");
		JSONArray ys = obj.getJSONArray("ys");
		quad = new Quad();
		for (int k=0; k < 4; ++k) {
			quad.xs[k] = xs.getInt(k);
			quad.ys[k] = ys.getInt(k);
		}
		if (!obj.isNull("refFile")) {
			refFile = new File(obj.getString("refFile"));
		}
		brightness = obj.getFloat("brightness");
		contrast = obj.getFloat("contrast");
		scale = obj.getFloat("scale");
		panX= obj.getFloat("panX");
		panY = obj.getFloat("panY");
		colorTemp = obj.getDouble("colorTemp");
		videoWidth = obj.getInt("videoWidth");
		videoHeight = obj.getInt("videoHeight");
	}
	
	public void saveJSON(File f) throws IOException {
		JSONObject obj = new JSONObject();
		JSONArray xs = new JSONArray();
		obj
			.put("version", 1)
			.put("xs", new JSONArray(quad.xs))
			.put("ys", new JSONArray(quad.ys))
			.put("brightness", brightness)
			.put("contrast", contrast)
			.put("scale", scale)
			.put("panX", panX)
			.put("panY", panY)
			.put("colorTemp", colorTemp)
			.put("videoWidth", videoWidth)
			.put("videoHeight", videoHeight);
		if (refFile == null) {obj.put("refFile", JSONObject.NULL);}
		else {obj.put("refFile", refFile.getAbsolutePath());}
		FileWriter writer = new FileWriter(f);
		writer.write(obj.toString());
		writer.close();
	}
	
	public Quad getQuad() {
		return quad;
	}
	public File getReference() {
		return refFile;
	}

	public float getBrightness() {
		return brightness;
	}

	public float getContrast() {
		return contrast;
	}

	public float getScale() {
		return scale;
	}

	public float getPanX() {
		return panX;
	}

	public float getPanY() {
		return panY;
	}

	public int getVideoWidth() {
		return videoWidth;
	}

	public int getVideoHeight() {
		return videoHeight;
	}

	public double getTemp() {
		return colorTemp;
	}
	
}
