/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.text.extraction.swt;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.text.extraction.swt.Candidate;
import org.openimaj.image.text.extraction.swt.LetterCandidate;
import org.openimaj.image.text.extraction.swt.SWTTextDetector;
import org.openimaj.image.text.extraction.swt.WordCandidate;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.pair.Pair;
import org.openimaj.util.set.DisjointSetForest;

public class LineCandidate
extends Candidate {
    protected List<LetterCandidate> letters = new ArrayList<LetterCandidate>();
    protected List<WordCandidate> words;

    protected LineCandidate() {
    }

    protected static List<LineCandidate> extractLines(List<LetterCandidate> letters, SWTTextDetector.Options options) {
        List<Pair<LetterCandidate>> pairs = LineCandidate.createLetterPairs(letters, options);
        Set sets = DisjointSetForest.partitionSubsets(pairs, (Comparator)new Comparator<Pair<LetterCandidate>>(){

            @Override
            public int compare(Pair<LetterCandidate> pair1, Pair<LetterCandidate> pair2) {
                int td;
                int tn;
                Pixel pair1d = this.computeDelta((LetterCandidate)pair1.firstObject(), (LetterCandidate)pair1.secondObject());
                Pixel pair2d = this.computeDelta((LetterCandidate)pair2.firstObject(), (LetterCandidate)pair2.secondObject());
                if (pair1.firstObject() == pair2.firstObject() || pair1.secondObject() == pair2.secondObject() ? (tn = pair1d.y * pair2d.x - pair1d.x * pair2d.y) * 7 < -(td = pair1d.x * pair2d.x + pair1d.y * pair2d.y) * 4 && tn * 7 > td * 4 : (pair1.firstObject() == pair2.secondObject() || pair1.secondObject() == pair2.firstObject()) && (tn = pair1d.y * pair2d.x - pair1d.x * pair2d.y) * 7 < (td = pair1d.x * pair2d.x + pair1d.y * pair2d.y) * 4 && tn * 7 > -td * 4) {
                    return 0;
                }
                return 1;
            }

            private Pixel computeDelta(LetterCandidate firstObject, LetterCandidate secondObject) {
                Rectangle frect = firstObject.regularBoundingBox;
                Rectangle srect = secondObject.regularBoundingBox;
                int dx = (int)(frect.x - srect.x + (frect.width - srect.width) / 2.0f);
                int dy = (int)(frect.y - srect.y + (frect.height - srect.height) / 2.0f);
                return new Pixel(dx, dy);
            }
        });
        ArrayList<LineCandidate> chains = new ArrayList<LineCandidate>();
        for (Set line : sets) {
            HashSet<Object> lcs = new HashSet<Object>();
            for (Pair p : line) {
                lcs.add(p.firstObject());
                lcs.add(p.secondObject());
            }
            if (lcs.size() < options.minLettersPerLine) continue;
            LineCandidate lc = new LineCandidate();
            lc.letters = new ArrayList<LetterCandidate>(lcs);
            for (LetterCandidate letter : lc.letters) {
                letter.line = lc;
            }
            lc.regularBoundingBox = LetterCandidate.computeBounds(lc.letters);
            lc.words = WordCandidate.extractWords(lc, options);
            chains.add(lc);
        }
        return chains;
    }

    private static List<Pair<LetterCandidate>> createLetterPairs(List<LetterCandidate> letters, SWTTextDetector.Options options) {
        ArrayList<Pair<LetterCandidate>> pairs = new ArrayList<Pair<LetterCandidate>>();
        int numLetters = letters.size();
        for (int j = 0; j < numLetters; ++j) {
            LetterCandidate l1 = letters.get(j);
            for (int i = j + 1; i < numLetters; ++i) {
                int oy;
                double distance;
                LetterCandidate l2 = letters.get(i);
                if (Math.max(l1.medianStrokeWidth, l2.medianStrokeWidth) / Math.min(l1.medianStrokeWidth, l2.medianStrokeWidth) > options.medianStrokeWidthRatio || Math.max(l1.regularBoundingBox.height, l2.regularBoundingBox.height) / Math.min(l1.regularBoundingBox.height, l2.regularBoundingBox.height) > options.letterHeightRatio || Math.abs(l1.averageBrightness - l2.averageBrightness) > options.intensityThreshold || Math.abs(distance = (double)(l1.centroid.x - l2.centroid.x)) > (double)(options.widthMultiplier * Math.max(l1.regularBoundingBox.width, l2.regularBoundingBox.width)) || (float)(oy = (int)(Math.min(l1.regularBoundingBox.y + l1.regularBoundingBox.height, l2.regularBoundingBox.y + l2.regularBoundingBox.height) - Math.max(l1.regularBoundingBox.y, l2.regularBoundingBox.y))) * options.intersectRatio < Math.min(l1.regularBoundingBox.height, l2.regularBoundingBox.height)) continue;
                pairs.add((Pair<LetterCandidate>)new Pair((Object)l1, (Object)l2));
            }
        }
        return pairs;
    }

    public List<LetterCandidate> getLetters() {
        return this.letters;
    }

    public List<WordCandidate> getWords() {
        return this.words;
    }
}

