/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.text.extraction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.connectedcomponent.ConnectedComponentLabeler;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.processing.convolution.CompassOperators;
import org.openimaj.image.processing.convolution.FConvolution;
import org.openimaj.image.processing.morphology.Close;
import org.openimaj.image.processing.morphology.Dilate;
import org.openimaj.image.processing.morphology.StructuringElement;
import org.openimaj.image.processing.morphology.Thin;
import org.openimaj.image.processing.threshold.OtsuThreshold;
import org.openimaj.image.processing.transform.SkewCorrector;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.processor.KernelProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;
import org.openimaj.image.text.extraction.TextExtractor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.pair.IndependentPair;

@Reference(type=ReferenceType.Inproceedings, author={"Xiaoqing Liu", "Samarabandu, J."}, title="An edge-based text region extraction algorithm for indoor mobile robot navigation", year="2005", booktitle="Mechatronics and Automation, 2005 IEEE International Conference", pages={" 701 ", " 706 Vol. 2"}, month="July-1 Aug.", number="", volume="2", customData={"keywords", "edge-based text region extraction; feature extraction; scene text; text localization; vision-based mobile robot navigation; character recognition; edge detection; feature extraction; mobile robots; navigation; path planning; robot vision;", "doi", "10.1109/ICMA.2005.1626635", "ISSN", ""})
public class LiuSamarabanduTextExtractorBasic
extends TextExtractor<FImage> {
    public static final boolean DEBUG = false;
    private float boundingBoxPaddingPc = 1.1f;
    private Map<Rectangle, FImage> textRegions = null;

    private FImage processImage(FImage img, FConvolution c) {
        return ((FImage)img.process((SinglebandImageProcessor)c)).abs().normalise();
    }

    public void processImage(FImage image) {
        FImage fmap = this.textRegionDetection(image);
        this.processFeatureMap(fmap, image);
        image.internalAssign(fmap);
    }

    public void processFeatureMap(FImage fmap, FImage image) {
        Map<Rectangle, FImage> t = this.textRegionLocalisation(fmap, image);
        this.textRegions = t;
    }

    public FImage textRegionDetection(FImage image) {
        HashMap<Integer, FImage> e = new HashMap<Integer, FImage>();
        e.put(0, this.processImage(image, (FConvolution)new CompassOperators.Compass0()));
        e.put(45, this.processImage(image, (FConvolution)new CompassOperators.Compass45()));
        e.put(90, this.processImage(image, (FConvolution)new CompassOperators.Compass90()));
        e.put(135, this.processImage(image, (FConvolution)new CompassOperators.Compass135()));
        FImage e90strong = (FImage)((FImage)e.get(90)).process((ImageProcessor)new OtsuThreshold());
        StructuringElement se = new StructuringElement();
        se.positive.add(new Pixel(0, 0));
        se.positive.add(new Pixel(-1, 0));
        se.positive.add(new Pixel(1, 0));
        FImage dilated = e90strong.process((KernelProcessor)new Dilate(se));
        int m = (int)((double)dilated.getHeight() / 25.0);
        StructuringElement se2 = new StructuringElement();
        for (int i = 0; i < m; ++i) {
            se2.positive.add(new Pixel(0, i - m / 2));
        }
        FImage closed = (FImage)dilated.process((ImageProcessor)new Close(se2));
        FImage e90weak = closed.subtract(dilated).abs();
        e90weak.multiplyInplace((FImage)e.get(90));
        e90weak = (FImage)e90weak.process((ImageProcessor)new OtsuThreshold());
        FImage e90edges = (FImage)e90strong.add(e90weak).normalise().process((ImageProcessor)new OtsuThreshold());
        FImage e90thin = (FImage)e90edges.process((ImageProcessor)new Thin(new StructuringElement[]{StructuringElement.BOX}));
        ConnectedComponentLabeler ccl = new ConnectedComponentLabeler(ConnectedComponent.ConnectMode.CONNECT_4);
        List<ConnectedComponent> cc = ccl.findComponents(e90thin);
        final FImage e90labelled = new FImage(e90thin.getWidth(), e90thin.getHeight());
        ConnectedComponentProcessor ccp = new ConnectedComponentProcessor(){

            public void process(ConnectedComponent cc) {
                int a = cc.calculateArea();
                for (Pixel p : cc.pixels) {
                    e90labelled.setPixel((int)p.getX(), (int)p.getY(), Float.valueOf(a));
                }
            }
        };
        ConnectedComponent.process(cc, (ConnectedComponentProcessor)ccp);
        FImage e90short = e90labelled.clone().clip(Float.valueOf(0.0f), Float.valueOf(1.0f)).subtract(e90labelled.threshold(Float.valueOf(e90labelled.max().floatValue() / 4.0f * 3.0f)));
        StructuringElement se3 = new StructuringElement();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                se3.positive.add(new Pixel(i - m / 2, j - m / 2));
            }
        }
        FImage e90candidate = e90short.process((KernelProcessor)new Dilate(se3));
        FImage is = ((FImage)e.get(0)).clone().addInplace((FImage)e.get(45)).addInplace((FImage)e.get(90)).addInplace((FImage)e.get(135));
        FImage refined = ((FImage)e90candidate.multiply((Image)is)).normalise();
        int c = 5;
        FImage fmap = new FImage(image.getWidth(), image.getHeight());
        HashMap<Integer, Float> maxPixDir = new HashMap<Integer, Float>();
        for (int j = 5; j < image.getHeight() - 5; ++j) {
            for (int i = 5; i < image.getWidth() - 5; ++i) {
                float pixelValue = 0.0f;
                float N = 25.0f;
                maxPixDir.clear();
                for (m = -5; m < 5; ++m) {
                    for (int n = -5; n < 5; ++n) {
                        pixelValue += refined.getPixel(i + m, j + n).floatValue();
                        this.updateMaxPixDir(maxPixDir, e, 0, i + m, j + n);
                        this.updateMaxPixDir(maxPixDir, e, 45, i + m, j + n);
                        this.updateMaxPixDir(maxPixDir, e, 90, i + m, j + n);
                        this.updateMaxPixDir(maxPixDir, e, 135, i + m, j + n);
                    }
                }
                float w = ((Float)maxPixDir.get(0)).floatValue() + ((Float)maxPixDir.get(45)).floatValue() + ((Float)maxPixDir.get(90)).floatValue() + ((Float)maxPixDir.get(135)).floatValue();
                pixelValue *= (w /= 4.0f);
                fmap.setPixel(i, j, Float.valueOf(pixelValue /= 25.0f));
            }
        }
        return fmap;
    }

    private void updateMaxPixDir(HashMap<Integer, Float> maxPixDir, HashMap<Integer, FImage> e, int dir, int x, int y) {
        Float xx = null;
        xx = maxPixDir.get(dir);
        if (xx == null) {
            maxPixDir.put(dir, e.get(dir).getPixel(x, y));
        } else {
            maxPixDir.put(dir, Float.valueOf(Math.max(xx.floatValue(), e.get(dir).getPixel(x, y).floatValue())));
        }
    }

    public Map<Rectangle, FImage> textRegionLocalisation(FImage fmap, FImage image) {
        Rectangle r;
        HashMap<Rectangle, FImage> textAreas = new HashMap<Rectangle, FImage>();
        FImage thresh = (FImage)fmap.clone().normalise().process((ImageProcessor)new OtsuThreshold());
        StructuringElement se = new StructuringElement();
        int ses = 9;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                se.positive.add(new Pixel(i, j));
            }
        }
        FImage dilated = thresh.process((KernelProcessor)new Dilate(se));
        ConnectedComponentLabeler ccl = new ConnectedComponentLabeler(ConnectedComponent.ConnectMode.CONNECT_4);
        List<ConnectedComponent> ccs = ccl.findComponents(dilated);
        System.out.println("Got " + ccs.size() + " connected components.");
        int maxArea = 0;
        for (PixelSet pixelSet : ccs) {
            maxArea = Math.max(maxArea, pixelSet.calculateArea());
        }
        Iterator<ConnectedComponent> cci = ccs.iterator();
        while (cci.hasNext()) {
            if (!((double)cci.next().calculateArea() < (double)maxArea / 20.0)) continue;
            cci.remove();
        }
        cci = ccs.iterator();
        while (cci.hasNext()) {
            PixelSet pixelSet = (PixelSet)cci.next();
            r = pixelSet.calculateRegularBoundingBox();
            if (!((double)(r.width / r.height) < 0.2)) continue;
            cci.remove();
        }
        for (PixelSet pixelSet : ccs) {
            if (pixelSet.getPixels().size() < 20) continue;
            r = pixelSet.calculateRegularBoundingBox();
            r.scaleCentroid(this.boundingBoxPaddingPc);
            FImage textArea = (FImage)image.extractROI(r);
            OtsuThreshold o = new OtsuThreshold();
            o.processImage(textArea);
            SkewCorrector sc = new SkewCorrector();
            sc.setAccuracy(4);
            textArea = (FImage)textArea.process((ImageProcessor)sc);
            textAreas.put(r, textArea);
        }
        return textAreas;
    }

    public List<IndependentPair<Point2d, Point2d>> calculateHomography(Polygon p) {
        ArrayList<IndependentPair<Point2d, Point2d>> pointPairs = new ArrayList<IndependentPair<Point2d, Point2d>>();
        List v = p.getVertices();
        Point2d p1 = (Point2d)v.get(0);
        Point2d p2 = (Point2d)v.get(1);
        Point2d p3 = (Point2d)v.get(2);
        Point2d p4 = (Point2d)v.get(3);
        Point2dImpl p1p = new Point2dImpl(p2.getX(), p1.getY());
        Point2d p2p = (Point2d)v.get(1);
        Point2dImpl p3p = new Point2dImpl(p3.getX(), p2.getY());
        Point2dImpl p4p = new Point2dImpl(p3p.getX(), p1.getY());
        pointPairs.add(new IndependentPair((Object)p1, (Object)p1p));
        pointPairs.add(new IndependentPair((Object)p2, (Object)p2p));
        pointPairs.add(new IndependentPair((Object)p3, (Object)p3p));
        pointPairs.add(new IndependentPair((Object)p4, (Object)p4p));
        return pointPairs;
    }

    public float getBoundingBoxPaddingPc() {
        return this.boundingBoxPaddingPc;
    }

    public void setBoundingBoxPaddingPc(float boundingBoxPaddingPc) {
        this.boundingBoxPaddingPc = boundingBoxPaddingPc;
    }

    @Override
    public Map<Rectangle, FImage> getTextRegions() {
        return this.textRegions;
    }
}

