/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.saliency;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.algorithm.HorizontalProjection;
import org.openimaj.image.analysis.algorithm.VerticalProjection;
import org.openimaj.image.saliency.DepthOfFieldEstimator;
import org.openimaj.image.saliency.SaliencyMapGenerator;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;

@Reference(type=ReferenceType.Inproceedings, author={"Luo, Yiwen", "Tang, Xiaoou"}, title="Photo and Video Quality Evaluation: Focusing on the Subject", year="2008", booktitle="Proceedings of the 10th European Conference on Computer Vision: Part III", pages={"386", "", "399"}, url="http://dx.doi.org/10.1007/978-3-540-88690-7_29", publisher="Springer-Verlag", series="ECCV '08", customData={"isbn", "978-3-540-88689-1", "location", "Marseille, France", "numpages", "14", "doi", "10.1007/978-3-540-88690-7_29", "acmid", "1478204", "address", "Berlin, Heidelberg"})
public class LuoTangSubjectRegion
implements SaliencyMapGenerator<FImage> {
    DepthOfFieldEstimator dofEstimator;
    Rectangle roi;
    private FImage dofMap;
    private float alpha = 0.9f;

    public LuoTangSubjectRegion() {
        this.dofEstimator = new DepthOfFieldEstimator();
    }

    public LuoTangSubjectRegion(float alpha, int maxKernelSize, int kernelSizeStep, int nbins, int windowSize) {
        this.dofEstimator = new DepthOfFieldEstimator(maxKernelSize, kernelSizeStep, nbins, windowSize);
        this.alpha = alpha;
    }

    public void analyseImage(FImage image) {
        image.analyseWith((ImageAnalyser)this.dofEstimator);
        this.dofMap = this.dofEstimator.getSaliencyMap();
        for (int y = 0; y < this.dofMap.height; ++y) {
            for (int x = 0; x < this.dofMap.width; ++x) {
                this.dofMap.pixels[y][x] = this.dofMap.pixels[y][x] == 0.0f ? 1.0f : 0.0f;
            }
        }
    }

    public Rectangle calculateROI() {
        float tmp;
        float[] pUx = HorizontalProjection.project((FImage)this.dofMap);
        float[] pUy = VerticalProjection.project((FImage)this.dofMap);
        float energy = 0.0f;
        for (float f : pUx) {
            energy += f;
        }
        float thresh = energy * ((1.0f - this.alpha) / 2.0f);
        int x1 = 0;
        for (tmp = pUx[x1]; tmp < thresh; tmp += pUx[++x1]) {
        }
        int y1 = 0;
        for (tmp = pUy[y1]; tmp < thresh; tmp += pUy[++y1]) {
        }
        int x2 = pUx.length - 1;
        for (tmp = pUx[x2]; tmp < thresh; tmp += pUx[--x2]) {
        }
        int y2 = pUy.length - 1;
        for (tmp = pUy[y2]; tmp < thresh; tmp += pUy[--y2]) {
        }
        return new Rectangle((float)x1, (float)y1, (float)(x2 - x1), (float)(y2 - y1));
    }

    @Override
    public FImage getSaliencyMap() {
        return this.dofMap;
    }

    public FImage getROIMap() {
        FImage image = new FImage(this.dofMap.width, this.dofMap.height);
        image.drawShapeFilled((Shape)this.calculateROI(), (Object)Float.valueOf(1.0f));
        return image;
    }
}

