/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel.statistics;

import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.statistics.HistogramModel;

public class MaskingHistogramModel
extends HistogramModel {
    private static final long serialVersionUID = 1L;
    private FImage mask;

    public MaskingHistogramModel(FImage mask, int ... nbins) {
        super(nbins);
        this.mask = mask;
    }

    @Override
    protected void accum(MBFImage im) {
        if (im.numBands() != this.ndims) {
            throw new AssertionError((Object)"number of bands must match");
        }
        for (int y = 0; y < im.getHeight(); ++y) {
            for (int x = 0; x < im.getWidth(); ++x) {
                if (this.mask.pixels[y][x] != 1.0f) continue;
                int[] bins = new int[this.ndims];
                for (int i = 0; i < this.ndims; ++i) {
                    bins[i] = (int)(((FImage)im.getBand((int)i)).pixels[y][x] * (float)this.histogram.nbins[i]);
                    if (bins[i] < this.histogram.nbins[i]) continue;
                    bins[i] = this.histogram.nbins[i] - 1;
                }
                int bin = 0;
                for (int i = 0; i < this.ndims; ++i) {
                    int f = 1;
                    for (int j = 0; j < i; ++j) {
                        f *= this.histogram.nbins[j];
                    }
                    bin += f * bins[i];
                }
                double[] dArray = (double[])this.histogram.values;
                int n = bin;
                dArray[n] = dArray[n] + 1.0;
            }
        }
    }
}

