/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.colour.ColourSpace;

@Reference(type=ReferenceType.Inproceedings, author={"Jose San Pedro", "Stefan Siersdorfer"}, title="Ranking and Classifying Attractiveness of Photos in Folksonomies", year="2009", booktitle="18th International World Wide Web Conference", pages={"771", "", "771"}, url="http://www2009.eprints.org/78/", month="April")
public class RGBRMSContrast
implements ImageAnalyser<MBFImage>,
FeatureVectorProvider<DoubleFV> {
    double contrast;

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.contrast});
    }

    public void analyseImage(MBFImage image) {
        int x;
        int y;
        int width = image.getWidth();
        int height = image.getHeight();
        image = ColourSpace.convert((MBFImage)image, (ColourSpace)ColourSpace.RGB);
        FImage r = (FImage)image.getBand(0);
        FImage g = (FImage)image.getBand(1);
        FImage b = (FImage)image.getBand(2);
        double avgr = 0.0;
        double avgg = 0.0;
        double avgb = 0.0;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                avgr += (double)r.pixels[y][x];
                avgg += (double)g.pixels[y][x];
                avgb += (double)b.pixels[y][x];
            }
        }
        avgr /= (double)(width * height);
        avgg /= (double)(width * height);
        avgb /= (double)(width * height);
        this.contrast = 0.0;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                double deltar = (double)r.pixels[y][x] - avgr;
                double deltag = (double)g.pixels[y][x] - avgg;
                double deltab = (double)b.pixels[y][x] - avgb;
                this.contrast += deltar * deltar + deltag * deltag + deltab * deltab;
            }
        }
        this.contrast /= (double)(height * width);
    }

    public double getContrast() {
        return this.contrast;
    }
}

