/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.procedure.TObjectFloatProcedure;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.statistics.MaskingHistogramModel;
import org.openimaj.image.processor.connectedcomponent.render.BoundingBoxRenderer;
import org.openimaj.image.saliency.YehSaliency;
import org.openimaj.math.statistics.distribution.MultidimensionalHistogram;
import org.openimaj.util.array.ArrayUtils;

@References(references={@Reference(type=ReferenceType.Inproceedings, author={"Luo, Yiwen", "Tang, Xiaoou"}, title="Photo and Video Quality Evaluation: Focusing on the Subject", year="2008", booktitle="Proceedings of the 10th European Conference on Computer Vision: Part III", pages={"386", "399"}, url="http://dx.doi.org/10.1007/978-3-540-88690-7_29", publisher="Springer-Verlag", series="ECCV '08", customData={"isbn", "978-3-540-88689-1", "location", "Marseille, France", "numpages", "14", "doi", "10.1007/978-3-540-88690-7_29", "acmid", "1478204", "address", "Berlin, Heidelberg"}), @Reference(type=ReferenceType.Inproceedings, author={"Che-Hua Yeh", "Yuan-Chen Ho", "Brian A. Barsky", "Ming Ouhyoung"}, title="Personalized Photograph Ranking and Selection System", year="2010", booktitle="Proceedings of ACM Multimedia", pages={"211", "220"}, month="October", customData={"location", "Florence, Italy"})})
public class ModifiedLuoSimplicity
implements ImageAnalyser<MBFImage>,
FeatureVectorProvider<DoubleFV> {
    protected YehSaliency extractor;
    protected float alpha = 0.67f;
    protected int binsPerBand = 16;
    protected float gamma = 0.01f;
    protected boolean boxMode = true;
    protected double simplicity;

    public ModifiedLuoSimplicity() {
        this.extractor = new YehSaliency();
    }

    public ModifiedLuoSimplicity(int binsPerBand, float gamma, boolean boxMode, float alpha, float saliencySigma, float segmenterSigma, float k, int minSize) {
        this.extractor = new YehSaliency(saliencySigma, segmenterSigma, k, minSize);
        this.binsPerBand = binsPerBand;
        this.gamma = gamma;
        this.boxMode = boxMode;
        this.alpha = alpha;
    }

    public void analyseImage(MBFImage image) {
        FImage mask;
        image.analyseWith((ImageAnalyser)this.extractor);
        if (this.boxMode) {
            TObjectFloatHashMap<ConnectedComponent> componentMap = this.extractor.getSaliencyComponents();
            float max = ArrayUtils.maxValue((float[])componentMap.values());
            mask = new FImage(image.getWidth(), image.getHeight());
            final float thresh = max * this.alpha;
            final BoundingBoxRenderer renderer = new BoundingBoxRenderer((Image)mask, (Object)Float.valueOf(1.0f), true);
            componentMap.forEachEntry((TObjectFloatProcedure)new TObjectFloatProcedure<ConnectedComponent>(){

                public boolean execute(ConnectedComponent cc, float sal) {
                    if (sal >= thresh) {
                        renderer.process(cc);
                    }
                    return true;
                }
            });
        } else {
            mask = this.extractor.getSaliencyMap();
            float maskthresh = mask.max().floatValue() * this.alpha;
            mask = mask.threshold(Float.valueOf(maskthresh));
        }
        mask = mask.inverse();
        MaskingHistogramModel hm = new MaskingHistogramModel(mask, this.binsPerBand, this.binsPerBand, this.binsPerBand);
        hm.estimateModel(image);
        MultidimensionalHistogram fv = hm.getFeatureVector();
        double thresh = (double)this.gamma * fv.max();
        int count = 0;
        for (double f : (double[])fv.values) {
            if (!(f >= thresh)) continue;
            ++count;
        }
        this.simplicity = (double)count / (double)((double[])fv.values).length;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.simplicity});
    }
}

