/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.binarypattern;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.Pixel;

@Reference(type=ReferenceType.Article, author={"Ojala, T.", "Pietikainen, M.", "Maenpaa, T."}, title="Multiresolution gray-scale and rotation invariant texture classification with local binary patterns", year="2002", journal="Pattern Analysis and Machine Intelligence, IEEE Transactions on", pages={"971 ", "987"}, month="jul", number="7", volume="24", customData={"doi", "10.1109/TPAMI.2002.1017623", "ISSN", "0162-8828"})
public class UniformBinaryPattern {
    protected static TIntObjectHashMap<TIntArrayList> lut = new TIntObjectHashMap();

    protected static TIntArrayList calculateUniformPatterns(int nbits) {
        TIntArrayList result = new TIntArrayList();
        boolean[] bits = new boolean[nbits];
        int i = 0;
        while ((double)i < Math.pow(2.0, nbits)) {
            Arrays.fill(bits, false);
            int temp = i;
            for (int j = 1; j <= nbits; ++j) {
                int pow = (int)Math.pow(2.0, nbits - j);
                if (temp / pow > 0) {
                    bits[j - 1] = true;
                }
                temp %= pow;
            }
            if (UniformBinaryPattern.isUniform(bits)) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    protected static boolean isUniform(boolean[] pattern) {
        int count = 0;
        for (int i = 0; i < pattern.length - 1; ++i) {
            if (pattern[i] == pattern[i + 1]) continue;
            ++count;
        }
        return count <= 2;
    }

    public static TIntArrayList getUniformPatterns(int nbits) {
        if (nbits < 1 || nbits > 32) {
            throw new IllegalArgumentException("Only patterns with lengths between 1 and 32 bits are supported");
        }
        TIntArrayList patterns = (TIntArrayList)lut.get(nbits);
        if (patterns == null) {
            patterns = UniformBinaryPattern.calculateUniformPatterns(nbits);
            lut.put(nbits, (Object)patterns);
        }
        return patterns;
    }

    public static boolean isPatternUniform(int pattern, int nbits) {
        return UniformBinaryPattern.getUniformPatterns(nbits).contains(pattern);
    }

    public static FImage extractPatternImage(int[][] patternImage, int code) {
        FImage image = new FImage(patternImage[0].length, patternImage.length);
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                if (patternImage[y][x] != code) continue;
                image.pixels[y][x] = 1.0f;
            }
        }
        return image;
    }

    public static FImage[] extractPatternImages(int[][] patternImage, int nbits) {
        TIntArrayList uniformPatterns = UniformBinaryPattern.getUniformPatterns(nbits);
        FImage[] images = new FImage[uniformPatterns.size() + 1];
        int width = patternImage[0].length;
        int height = patternImage.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int idx = uniformPatterns.indexOf(patternImage[y][x]);
                if (images[idx + 1] == null) {
                    images[idx + 1] = new FImage(width, height);
                }
                images[idx + 1].pixels[y][x] = 1.0f;
            }
        }
        return images;
    }

    public static boolean[][][] extractPatternMaps(int[][] patternImage, int nbits) {
        TIntArrayList uniformPatterns = UniformBinaryPattern.getUniformPatterns(nbits);
        int width = patternImage[0].length;
        int height = patternImage.length;
        boolean[][][] maps = new boolean[uniformPatterns.size() + 1][height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int idx = uniformPatterns.indexOf(patternImage[y][x]);
                maps[idx + 1][y][x] = true;
            }
        }
        return maps;
    }

    public static List<List<Pixel>> extractPatternPixels(int[][] patternImage, int nbits) {
        TIntArrayList uniformPatterns = UniformBinaryPattern.getUniformPatterns(nbits);
        ArrayList<List<Pixel>> images = new ArrayList<List<Pixel>>(uniformPatterns.size() + 1);
        int width = patternImage[0].length;
        int height = patternImage.length;
        for (int i = 0; i < uniformPatterns.size() + 1; ++i) {
            images.add(null);
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int idx = uniformPatterns.indexOf(patternImage[y][x]);
                if (images.get(idx + 1) == null) {
                    images.set(idx + 1, new ArrayList());
                }
                ((List)images.get(idx + 1)).add(new Pixel(x, y));
            }
        }
        return images;
    }

    static {
        lut.put(8, (Object)UniformBinaryPattern.calculateUniformPatterns(8));
    }
}

