/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.binarypattern;

import gnu.trove.list.array.TIntArrayList;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.FloatFV;
import org.openimaj.image.feature.dense.binarypattern.UniformBinaryPattern;

@Reference(type=ReferenceType.Article, author={"Ojala, T.", "Pietikainen, M.", "Maenpaa, T."}, title="Multiresolution gray-scale and rotation invariant texture classification with local binary patterns", year="2002", journal="Pattern Analysis and Machine Intelligence, IEEE Transactions on", pages={"971 ", "987"}, month="jul", number="7", volume="24", customData={"doi", "10.1109/TPAMI.2002.1017623", "ISSN", "0162-8828"})
public class LocalUniformBinaryPatternHistogram {
    protected int blocksize_x;
    protected int blocksize_y;
    FloatFV[][] histograms;

    public LocalUniformBinaryPatternHistogram(int blocksize_x, int blocksize_y) {
        this.blocksize_x = blocksize_x;
        this.blocksize_y = blocksize_y;
    }

    public void calculateHistograms(int[][] patternImage, int nbits) {
        int height = patternImage.length;
        int width = patternImage[0].length;
        TIntArrayList uniformPatterns = UniformBinaryPattern.getUniformPatterns(nbits);
        this.histograms = new FloatFV[(int)Math.ceil((double)height / (double)this.blocksize_y)][(int)Math.ceil((double)width / (double)this.blocksize_x)];
        int y = 0;
        int j = 0;
        while (y < height) {
            int x = 0;
            int i = 0;
            while (x < width) {
                this.histograms[j][i] = new FloatFV(uniformPatterns.size() + 1);
                for (int yy = y; yy < Math.min(height, y + this.blocksize_y); ++yy) {
                    for (int xx = x; xx < Math.min(width, x + this.blocksize_x); ++xx) {
                        int idx = uniformPatterns.indexOf(patternImage[yy][xx]);
                        float[] fArray = (float[])this.histograms[j][i].values;
                        int n = idx + 1;
                        fArray[n] = fArray[n] + 1.0f;
                    }
                }
                x += this.blocksize_x;
                ++i;
            }
            y += this.blocksize_y;
            ++j;
        }
    }

    public FloatFV[][] getHistograms() {
        return this.histograms;
    }

    public FloatFV getHistogram() {
        int len = this.histograms[0][0].length();
        FloatFV h = new FloatFV(this.histograms.length * this.histograms[0].length * len);
        for (int j = 0; j < this.histograms.length; ++j) {
            for (int i = 0; i < this.histograms[0].length; ++i) {
                int blkid = i + j * this.histograms[0].length;
                System.arraycopy(this.histograms[j][i].values, 0, h.values, blkid * len, len);
            }
        }
        return h;
    }
}

