/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.contour;

import java.util.ArrayList;
import java.util.HashMap;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.contour.Contour;
import org.openimaj.image.contour.ContourType;
import org.openimaj.image.contour.Direction;
import org.openimaj.image.contour.SuzukiNeighborStrategy;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.function.Operation;
import org.openimaj.util.pair.IndependentPair;

@Reference(type=ReferenceType.Article, author={"Suzuki, S.", "Abe, K."}, title="Topological Structural Analysis of Digitized Binary Image by Border Following", year="1985", journal="Computer Vision, Graphics and Image Processing", pages={"32", "46"}, month="January", number="1", volume="30")
public class SuzukiContourProcessor
implements ImageAnalyser<FImage> {
    public Contour root;
    private double minRelativeChildProp = -1.0;

    public void analyseImage(FImage image) {
        this.root = SuzukiContourProcessor.findContours(image, this);
    }

    public static Contour findContours(FImage image) {
        return SuzukiContourProcessor.findContours(image, new SuzukiContourProcessor());
    }

    public static Contour findContours(final FImage image, SuzukiContourProcessor proc) {
        final float[] nbd = new float[]{1.0f};
        float[] lnbd = new float[]{1.0f};
        Contour root = new Contour(ContourType.HOLE);
        Rectangle bb = image.getBounds();
        root.points.addAll(bb.asPolygon().getVertices());
        root.finish();
        HashMap<Float, Contour> borderMap = new HashMap<Float, Contour>();
        borderMap.put(Float.valueOf(lnbd[0]), root);
        SuzukiNeighborStrategy borderFollow = new SuzukiNeighborStrategy();
        for (int i = 0; i < image.height; ++i) {
            lnbd[0] = 1.0f;
            for (int j = 0; j < image.width; ++j) {
                float fji = image.getPixel(j, i).floatValue();
                boolean isOuter = SuzukiContourProcessor.isOuterBorderStart(image, i, j);
                boolean isHole = SuzukiContourProcessor.isHoleBorderStart(image, i, j);
                if (isOuter || isHole) {
                    final Contour border = new Contour(j, i);
                    Contour borderPrime = null;
                    Pixel from = new Pixel(j, i);
                    if (isOuter) {
                        nbd[0] = nbd[0] + 1.0f;
                        --from.x;
                        border.type = ContourType.OUTER;
                        borderPrime = (Contour)((Object)borderMap.get(Float.valueOf(lnbd[0])));
                        switch (borderPrime.type) {
                            case OUTER: {
                                border.setParent(borderPrime.parent);
                                break;
                            }
                            case HOLE: {
                                border.setParent(borderPrime);
                            }
                        }
                    } else {
                        nbd[0] = nbd[0] + 1.0f;
                        if (fji > 1.0f) {
                            lnbd[0] = fji;
                        }
                        borderPrime = (Contour)((Object)borderMap.get(Float.valueOf(lnbd[0])));
                        ++from.x;
                        border.type = ContourType.HOLE;
                        switch (borderPrime.type) {
                            case OUTER: {
                                border.setParent(borderPrime);
                                break;
                            }
                            case HOLE: {
                                border.setParent(borderPrime.parent);
                            }
                        }
                    }
                    Pixel ij = new Pixel(j, i);
                    borderFollow.directedContour(image, ij, from, new Operation<IndependentPair<Pixel, boolean[]>>(){

                        public void perform(IndependentPair<Pixel, boolean[]> object) {
                            Pixel p = (Pixel)object.firstObject();
                            boolean[] d = (boolean[])object.secondObject();
                            border.points.add(p);
                            if (SuzukiContourProcessor.crossesEastBorder(image, d, p)) {
                                image.setPixel(p.x, p.y, Float.valueOf(-nbd[0]));
                            } else if (((Float)image.getPixel(p)).floatValue() == 1.0f) {
                                image.setPixel(p.x, p.y, Float.valueOf(nbd[0]));
                            }
                        }
                    });
                    if (border.points.size() == 0) {
                        border.points.add(ij);
                        image.setPixel(j, i, Float.valueOf(-nbd[0]));
                    }
                    border.finish();
                    borderMap.put(Float.valueOf(nbd[0]), border);
                }
                if (fji == 0.0f || fji == 1.0f) continue;
                lnbd[0] = Math.abs(fji);
            }
        }
        if (proc.minRelativeChildProp > 0.0) {
            SuzukiContourProcessor.removeSmall(root, proc.minRelativeChildProp);
        }
        return root;
    }

    private static void removeSmall(Contour root, double minRelativeChildProp) {
        ArrayList<Contour> toSearch = new ArrayList<Contour>();
        toSearch.add(root);
        while (toSearch.size() != 0) {
            Contour ret = (Contour)((Object)toSearch.remove(0));
            if (ret.parent != null && ret.rect.calculateArea() / ret.parent.rect.calculateArea() < minRelativeChildProp) {
                ret.parent.children.remove((Object)ret);
                continue;
            }
            toSearch.addAll(ret.children);
        }
    }

    private static boolean crossesEastBorder(FImage image, boolean[] checked, Pixel p) {
        boolean b = checked[Direction.fromTo(p, new Pixel(p.x + 1, p.y)).ordinal()];
        return ((Float)image.getPixel(p)).floatValue() != 0.0f && (p.x == image.width - 1 || b);
    }

    private static boolean isOuterBorderStart(FImage image, int i, int j) {
        return image.pixels[i][j] == 1.0f && (j == 0 || image.pixels[i][j - 1] == 0.0f);
    }

    private static boolean isHoleBorderStart(FImage image, int i, int j) {
        return image.pixels[i][j] >= 1.0f && (j == image.width - 1 || image.pixels[i][j + 1] == 0.0f);
    }

    public void setMinRelativeChildProp(double d) {
        this.minRelativeChildProp = d;
    }
}

