/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.contour;

import org.openimaj.image.FImage;
import org.openimaj.image.contour.ContourFollowingStrategy;
import org.openimaj.image.contour.Direction;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.util.function.Operation;
import org.openimaj.util.pair.IndependentPair;

public class MooreNeighborStrategy
extends ContourFollowingStrategy {
    @Override
    public void contour(FImage image, Pixel start, Pixel from, final Operation<Pixel> operation) {
        this.directedContour(image, start, from, new Operation<IndependentPair<Pixel, Direction>>(){

            public void perform(IndependentPair<Pixel, Direction> object) {
                operation.perform(object.firstObject());
            }
        });
    }

    public void directedContour(FImage image, Pixel start, Pixel from, Operation<IndependentPair<Pixel, Direction>> operation) {
        Pixel p = start;
        if (image.pixels[start.y][start.x] == 0.0f) {
            return;
        }
        Direction cdirStart = Direction.fromTo(p, from);
        operation.perform((Object)IndependentPair.pair((Object)start, (Object)((Object)cdirStart)));
        Direction firstCdir = cdirStart;
        Direction cdir = cdirStart.clockwise();
        int startCount = 0;
        while (cdir != cdirStart) {
            Pixel c = cdir.active(image, p);
            if (c != null) {
                cdirStart = cdir.clockwiseEntryDirection();
                if (c.equals((Object)start) && (++startCount >= 2 || firstCdir == cdirStart)) {
                    return;
                }
                operation.perform((Object)IndependentPair.pair((Object)c, (Object)((Object)cdirStart)));
                p = c;
                cdir = cdirStart.clockwise();
                continue;
            }
            cdir = cdir.clockwise();
        }
    }
}

