/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NamedList<T>
implements Cloneable,
Serializable,
Iterable<Map.Entry<String, T>> {
    private static final long serialVersionUID = 1957981902839867821L;
    protected final List<Object> nvPairs;

    public NamedList() {
        this.nvPairs = new ArrayList<Object>();
    }

    public NamedList(Map.Entry<String, ? extends T>[] nameValuePairs) {
        this.nvPairs = this.nameValueMapToList(nameValuePairs);
    }

    @Deprecated
    public NamedList(List<Object> nameValuePairs) {
        this.nvPairs = nameValuePairs;
    }

    @Deprecated
    private List<Object> nameValueMapToList(Map.Entry<String, ? extends T>[] nameValuePairs) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<String, T> entry : nameValuePairs) {
            result.add(entry.getKey());
            result.add(entry.getValue());
        }
        return result;
    }

    public int size() {
        return this.nvPairs.size() >> 1;
    }

    public String getName(int idx) {
        return (String)this.nvPairs.get(idx << 1);
    }

    public T getVal(int idx) {
        return (T)this.nvPairs.get((idx << 1) + 1);
    }

    public void add(String name, T val) {
        this.nvPairs.add(name);
        this.nvPairs.add(val);
    }

    public void setName(int idx, String name) {
        this.nvPairs.set(idx << 1, name);
    }

    public T setVal(int idx, T val) {
        int index = (idx << 1) + 1;
        Object old = this.nvPairs.get(index);
        this.nvPairs.set(index, val);
        return (T)old;
    }

    public T remove(int idx) {
        int index = idx << 1;
        this.nvPairs.remove(index);
        Object result = this.nvPairs.remove(index);
        return (T)result;
    }

    public int indexOf(String name, int start) {
        int sz = this.size();
        for (int i = start; i < sz; ++i) {
            String n = this.getName(i);
            if (!(name == null ? n == null : name.equals(n))) continue;
            return i;
        }
        return -1;
    }

    public T get(String name) {
        return this.get(name, 0);
    }

    public T get(String name, int start) {
        int sz = this.size();
        for (int i = start; i < sz; ++i) {
            String n = this.getName(i);
            if (!(name == null ? n == null : name.equals(n))) continue;
            return this.getVal(i);
        }
        return null;
    }

    public List<T> getAll(String name) {
        ArrayList<T> result = new ArrayList<T>();
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            String n = this.getName(i);
            if (name != n && (name == null || !name.equals(n))) continue;
            result.add(this.getVal(i));
        }
        return result;
    }

    public Object findRecursive(String ... args) {
        NamedList currentList = null;
        Object value = null;
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (currentList == null) {
                currentList = this;
            } else if (value instanceof NamedList) {
                currentList = value;
            } else {
                value = null;
                break;
            }
            value = currentList.get(key, 0);
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.getName(i));
            sb.append('=');
            sb.append(this.getVal(i));
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean addAll(Map<String, T> args) {
        for (Map.Entry<String, T> entry : args.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return args.size() > 0;
    }

    public boolean addAll(NamedList<T> nl) {
        this.nvPairs.addAll(nl.nvPairs);
        return nl.size() > 0;
    }

    public NamedList<T> clone() {
        ArrayList<Object> newList = new ArrayList<Object>(this.nvPairs.size());
        newList.addAll(this.nvPairs);
        return new NamedList<T>(newList);
    }

    @Override
    public Iterator<Map.Entry<String, T>> iterator() {
        final NamedList list = this;
        Iterator iter = new Iterator<Map.Entry<String, T>>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < list.size();
            }

            @Override
            public Map.Entry<String, T> next() {
                final int index = this.idx++;
                Map.Entry nv = new Map.Entry<String, T>(){

                    @Override
                    public String getKey() {
                        return list.getName(index);
                    }

                    @Override
                    public T getValue() {
                        return list.getVal(index);
                    }

                    public String toString() {
                        return this.getKey() + "=" + this.getValue();
                    }

                    @Override
                    public T setValue(T value) {
                        return list.setVal(index, value);
                    }
                };
                return nv;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iter;
    }

    public T remove(String name) {
        int idx = this.indexOf(name, 0);
        if (idx != -1) {
            return this.remove(idx);
        }
        return null;
    }

    public void clear() {
        this.nvPairs.clear();
    }

    public int hashCode() {
        return ((Object)this.nvPairs).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NamedList)) {
            return false;
        }
        NamedList nl = (NamedList)obj;
        return ((Object)this.nvPairs).equals(nl.nvPairs);
    }

    public static final class NamedListEntry<T>
    implements Map.Entry<String, T> {
        private String key;
        private T value;

        public NamedListEntry() {
        }

        public NamedListEntry(String _key, T _value) {
            this.key = _key;
            this.value = _value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T _value) {
            T oldValue = this.value;
            this.value = _value;
            return oldValue;
        }
    }
}

