/*
 * Decompiled with CFR 0.152.
 */
package com.twitter;

import com.twitter.Regex;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Autolink {
    public static final String DEFAULT_URL_CLASS = "tweet-url";
    public static final String DEFAULT_LIST_CLASS = "list-slug";
    public static final String DEFAULT_USERNAME_CLASS = "username";
    public static final String DEFAULT_HASHTAG_CLASS = "hashtag";
    public static final String DEFAULT_USERNAME_URL_BASE = "http://twitter.com/";
    public static final String DEFAULT_LIST_URL_BASE = "http://twitter.com/";
    public static final String DEFAULT_HASHTAG_URL_BASE = "http://twitter.com/search?q=%23";
    public static final String NO_FOLLOW_HTML_ATTRIBUTE = " rel=\"nofollow\"";
    protected String urlClass = "tweet-url";
    protected String listClass = "list-slug";
    protected String usernameClass = "username";
    protected String hashtagClass = "hashtag";
    protected String usernameUrlBase = "http://twitter.com/";
    protected String listUrlBase = "http://twitter.com/";
    protected String hashtagUrlBase = "http://twitter.com/search?q=%23";
    protected boolean noFollow = true;

    public String escapeBrackets(String text) {
        int len = text.length();
        if (len == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(len + 16);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String autoLink(String text) {
        return this.autoLinkUsernamesAndLists(this.autoLinkURLs(this.autoLinkHashtags(this.escapeBrackets(text))));
    }

    public String autoLinkUsernamesAndLists(String text) {
        int capacity = text.length() * 2;
        StringBuffer sb = new StringBuffer(capacity);
        Iterable<String> chunks = Autolink.split(text, "<>");
        int i = 0;
        for (String chunk : chunks) {
            if (0 != i) {
                if (i % 2 == 0) {
                    sb.append(">");
                } else {
                    sb.append("<");
                }
            }
            if (i % 4 != 0) {
                sb.append(chunk);
            } else {
                Matcher matcher = Regex.AUTO_LINK_USERNAMES_OR_LISTS.matcher(chunk);
                while (matcher.find()) {
                    StringBuilder rb;
                    if (matcher.group(4) == null || matcher.group(4).isEmpty()) {
                        if (!Regex.SCREEN_NAME_MATCH_END.matcher(chunk.substring(matcher.end())).find()) {
                            rb = new StringBuilder(capacity);
                            rb.append(matcher.group(1)).append(matcher.group(2)).append("<a class=\"").append(this.urlClass).append(" ").append(this.usernameClass).append("\" href=\"").append(this.usernameUrlBase).append(matcher.group(3)).append("\"");
                            if (this.noFollow) {
                                rb.append(NO_FOLLOW_HTML_ATTRIBUTE);
                            }
                            rb.append(">").append(matcher.group(3)).append("</a>");
                            matcher.appendReplacement(sb, rb.toString());
                            continue;
                        }
                        matcher.appendReplacement(sb, matcher.group(0));
                        continue;
                    }
                    rb = new StringBuilder(capacity);
                    rb.append(matcher.group(1)).append(matcher.group(2)).append("<a class=\"").append(this.urlClass).append(" ").append(this.listClass).append("\" href=\"").append(this.listUrlBase).append(matcher.group(3)).append(matcher.group(4)).append("\"");
                    if (this.noFollow) {
                        rb.append(NO_FOLLOW_HTML_ATTRIBUTE);
                    }
                    rb.append(">").append(matcher.group(3)).append(matcher.group(4)).append("</a>");
                    matcher.appendReplacement(sb, rb.toString());
                }
                matcher.appendTail(sb);
            }
            ++i;
        }
        return sb.toString();
    }

    public String autoLinkHashtags(String text) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = Regex.AUTO_LINK_HASHTAGS.matcher(text);
        while (matcher.find()) {
            String after = text.substring(matcher.end());
            if (!Regex.HASHTAG_MATCH_END.matcher(after).find()) {
                StringBuilder replacement = new StringBuilder(text.length() * 2);
                replacement.append(matcher.group(1)).append("<a href=\"").append(this.hashtagUrlBase).append(matcher.group(3)).append("\"").append(" title=\"#").append(matcher.group(3)).append("\" class=\"").append(this.urlClass).append(" ").append(this.hashtagClass).append("\"");
                if (this.noFollow) {
                    replacement.append(NO_FOLLOW_HTML_ATTRIBUTE);
                }
                replacement.append(">").append(matcher.group(2)).append(matcher.group(3)).append("</a>");
                matcher.appendReplacement(sb, replacement.toString());
                continue;
            }
            matcher.appendReplacement(sb, "$0");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String autoLinkURLs(String text) {
        Matcher matcher = Regex.VALID_URL.matcher(text);
        int capacity = text.length() * 2;
        StringBuffer sb = new StringBuffer(capacity);
        while (matcher.find()) {
            String protocol = matcher.group(4);
            if (protocol != null) {
                String url = matcher.group(3);
                String after = "";
                Matcher tco_matcher = Regex.VALID_TCO_URL.matcher(url);
                if (tco_matcher.find()) {
                    after = url.substring(tco_matcher.end());
                    url = tco_matcher.group();
                } else {
                    String query_string = matcher.group(8);
                    if (query_string != null) {
                        int us = matcher.start(3);
                        int qs = matcher.start(8);
                        int qe = matcher.end(8);
                        String replacement = StringEscapeUtils.escapeHtml((String)query_string);
                        url = url.substring(0, qs - us) + replacement + url.substring(qe - us);
                    }
                    if (url.indexOf(36) != -1) {
                        url = url.replace("$", "\\$");
                    }
                }
                StringBuilder rb = new StringBuilder(capacity);
                rb.append(matcher.group(2)).append("<a href=\"").append(url).append("\"");
                if (this.noFollow) {
                    rb.append(NO_FOLLOW_HTML_ATTRIBUTE);
                }
                rb.append(">").append(url).append("</a>").append(after);
                matcher.appendReplacement(sb, rb.toString());
                continue;
            }
            matcher.appendReplacement(sb, matcher.group(1));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String getUrlClass() {
        return this.urlClass;
    }

    public void setUrlClass(String urlClass) {
        this.urlClass = urlClass;
    }

    public String getListClass() {
        return this.listClass;
    }

    public void setListClass(String listClass) {
        this.listClass = listClass;
    }

    public String getUsernameClass() {
        return this.usernameClass;
    }

    public void setUsernameClass(String usernameClass) {
        this.usernameClass = usernameClass;
    }

    public String getHashtagClass() {
        return this.hashtagClass;
    }

    public void setHashtagClass(String hashtagClass) {
        this.hashtagClass = hashtagClass;
    }

    public String getUsernameUrlBase() {
        return this.usernameUrlBase;
    }

    public void setUsernameUrlBase(String usernameUrlBase) {
        this.usernameUrlBase = usernameUrlBase;
    }

    public String getListUrlBase() {
        return this.listUrlBase;
    }

    public void setListUrlBase(String listUrlBase) {
        this.listUrlBase = listUrlBase;
    }

    public String getHashtagUrlBase() {
        return this.hashtagUrlBase;
    }

    public void setHashtagUrlBase(String hashtagUrlBase) {
        this.hashtagUrlBase = hashtagUrlBase;
    }

    public boolean isNoFollow() {
        return this.noFollow;
    }

    public void setNoFollow(boolean noFollow) {
        this.noFollow = noFollow;
    }

    protected static Iterable<String> split(String s, String d) {
        ArrayList<String> strings = new ArrayList<String>();
        int length = s.length();
        int current = 0;
        while (current < length) {
            int minIndex = Integer.MAX_VALUE;
            for (char c : d.toCharArray()) {
                int index = s.indexOf(c, current);
                if (index == -1 || index >= minIndex) continue;
                minIndex = index;
            }
            if (minIndex == Integer.MAX_VALUE) {
                strings.add(s.substring(current));
                current = length;
                continue;
            }
            strings.add(s.substring(current, minIndex));
            current = minIndex + 1;
            if (current != length) continue;
            strings.add("");
        }
        return strings;
    }
}

