/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms.residuals;

import Jama.Matrix;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.model.Model;
import org.openimaj.math.model.fit.residuals.ResidualCalculator;
import org.openimaj.util.pair.IndependentPair;

public class TransformedSITR2d<M extends Model<Point2d, Point2d>>
implements ResidualCalculator<Point2d, Point2d, M> {
    Matrix t1;
    Matrix t2;
    M model;

    public TransformedSITR2d(Matrix t1, Matrix t2) {
        this.t1 = t1;
        this.t2 = t2;
    }

    @Override
    public void setModel(M model) {
        this.model = model;
    }

    @Override
    public double computeResidual(IndependentPair<Point2d, Point2d> data) {
        Point2d p2_est = ((Point2d)this.model.predict((Object)data.firstObject())).transform(this.t1);
        Point2d so = ((Point2d)data.secondObject()).transform(this.t2);
        float dx = so.getX() - p2_est.getX();
        float dy = so.getY() - p2_est.getY();
        return dx * dx + dy * dy;
    }

    @Override
    public void computeResiduals(List<? extends IndependentPair<Point2d, Point2d>> data, double[] errors) {
        for (int i = 0; i < data.size(); ++i) {
            Point2d p2_est = ((Point2d)this.model.predict((Object)data.get(i).firstObject())).transform(this.t1);
            Point2d so = ((Point2d)data.get(i).secondObject()).transform(this.t2);
            float dx = so.getX() - p2_est.getX();
            float dy = so.getY() - p2_est.getY();
            errors[i] = dx * dx + dy * dy;
        }
    }
}

