/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape.util;

import net.jafama.FastMath;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.RotatedRectangle;

public final class RotatingCalipers {
    private static final double ANGLE_0DEG_IN_RADS = 0.0;
    private static final double ANGLE_90DEG_IN_RADS = 1.5707963267948966;
    private static final double ANGLE_180DEG_IN_RADS = Math.PI;
    private static final double ANGLE_270DEG_IN_RADS = 4.71238898038469;
    private static final double ANGLE_360DEG_IN_RADS = Math.PI * 2;

    private static double getArea(Point2dImpl[] rectangle) {
        double deltaXAB = rectangle[0].x - rectangle[1].x;
        double deltaYAB = rectangle[0].y - rectangle[1].y;
        double deltaXBC = rectangle[1].x - rectangle[2].x;
        double deltaYBC = rectangle[1].y - rectangle[2].y;
        double lengthAB = FastMath.sqrt((double)(deltaXAB * deltaXAB + deltaYAB * deltaYAB));
        double lengthBC = FastMath.sqrt((double)(deltaXBC * deltaXBC + deltaYBC * deltaYBC));
        return lengthAB * lengthBC;
    }

    public static RotatedRectangle getMinimumBoundingRectangle(Polygon poly, boolean assumeSimple) {
        Polygon convexHull;
        Polygon polygon = convexHull = assumeSimple ? poly.calculateConvexHullMelkman() : poly.calculateConvexHull();
        if (convexHull.size() < 3) {
            return new RotatedRectangle(convexHull.calculateRegularBoundingBox(), 0.0f);
        }
        Point2dImpl[] minimum = null;
        double minimumAngle = 0.0;
        double area = Double.MAX_VALUE;
        Caliper I = new Caliper(convexHull, RotatingCalipers.getIndex(convexHull, Corner.UPPER_RIGHT), 1.5707963267948966);
        Caliper J = new Caliper(convexHull, RotatingCalipers.getIndex(convexHull, Corner.UPPER_LEFT), Math.PI);
        Caliper K = new Caliper(convexHull, RotatingCalipers.getIndex(convexHull, Corner.LOWER_LEFT), 4.71238898038469);
        Caliper L = new Caliper(convexHull, RotatingCalipers.getIndex(convexHull, Corner.LOWER_RIGHT), 0.0);
        while (L.currentAngle < 1.5707963267948966) {
            Point2dImpl[] rectangle = new Point2dImpl[]{L.getIntersection(I), I.getIntersection(J), J.getIntersection(K), K.getIntersection(L)};
            double tempArea = RotatingCalipers.getArea(rectangle);
            if (minimum == null || tempArea < area) {
                minimum = rectangle;
                minimumAngle = L.currentAngle;
                area = tempArea;
            }
            double smallestTheta = RotatingCalipers.getSmallestTheta(I, J, K, L);
            I.rotateBy(smallestTheta);
            J.rotateBy(smallestTheta);
            K.rotateBy(smallestTheta);
            L.rotateBy(smallestTheta);
        }
        return RotatingCalipers.makeRotated(minimum, minimumAngle);
    }

    private static RotatedRectangle makeRotated(Point2dImpl[] rectangle, double angle) {
        double deltaXAB = rectangle[0].x - rectangle[1].x;
        double deltaYAB = rectangle[0].y - rectangle[1].y;
        double deltaXBC = rectangle[1].x - rectangle[2].x;
        double deltaYBC = rectangle[1].y - rectangle[2].y;
        double lengthAB = FastMath.sqrt((double)(deltaXAB * deltaXAB + deltaYAB * deltaYAB));
        double lengthBC = FastMath.sqrt((double)(deltaXBC * deltaXBC + deltaYBC * deltaYBC));
        double cx = (rectangle[0].x + rectangle[1].x + rectangle[2].x + rectangle[3].x) / 4.0f;
        double cy = (rectangle[0].y + rectangle[1].y + rectangle[2].y + rectangle[3].y) / 4.0f;
        return new RotatedRectangle(cx, cy, lengthBC, lengthAB, angle);
    }

    private static double getSmallestTheta(Caliper I, Caliper J, Caliper K, Caliper L) {
        double thetaI = I.getDeltaAngleNextPoint();
        double thetaJ = J.getDeltaAngleNextPoint();
        double thetaK = K.getDeltaAngleNextPoint();
        double thetaL = L.getDeltaAngleNextPoint();
        if (thetaI <= thetaJ && thetaI <= thetaK && thetaI <= thetaL) {
            return thetaI;
        }
        if (thetaJ <= thetaK && thetaJ <= thetaL) {
            return thetaJ;
        }
        if (thetaK <= thetaL) {
            return thetaK;
        }
        return thetaL;
    }

    protected static int getIndex(Polygon convexHull, Corner corner) {
        int index = 0;
        Point2d point = (Point2d)convexHull.points.get(index);
        float px = point.getX();
        float py = point.getY();
        for (int i = 1; i < convexHull.size() - 1; ++i) {
            Point2d temp = (Point2d)convexHull.points.get(i);
            boolean change = false;
            float tx = temp.getX();
            float ty = temp.getY();
            switch (corner) {
                case UPPER_RIGHT: {
                    change = tx > px || tx == px && ty > py;
                    break;
                }
                case UPPER_LEFT: {
                    change = ty > py || ty == py && tx < px;
                    break;
                }
                case LOWER_LEFT: {
                    change = tx < px || tx == px && ty < py;
                    break;
                }
                case LOWER_RIGHT: {
                    boolean bl = change = ty < py || ty == py && tx > px;
                }
            }
            if (!change) continue;
            index = i;
            px = tx;
            py = ty;
        }
        return index;
    }

    protected static class Caliper {
        static final double SIGMA = 1.0E-11;
        final Polygon convexHull;
        int pointIndex;
        double currentAngle;

        Caliper(Polygon convexHull, int pointIndex, double currentAngle) {
            this.convexHull = convexHull;
            this.pointIndex = pointIndex;
            this.currentAngle = currentAngle;
        }

        double getAngleNextPoint() {
            Point2d p1 = this.convexHull.get(this.pointIndex);
            Point2d p2 = this.convexHull.get((this.pointIndex + 1) % this.convexHull.size());
            double deltaX = p2.getX() - p1.getX();
            double deltaY = p2.getY() - p1.getY();
            double angle = FastMath.atan2((double)deltaY, (double)deltaX);
            return angle < 0.0 ? Math.PI * 2 + angle : angle;
        }

        double getConstant() {
            Point2d p = this.convexHull.get(this.pointIndex);
            return (double)p.getY() - this.getSlope() * (double)p.getX();
        }

        double getDeltaAngleNextPoint() {
            double angle = this.getAngleNextPoint();
            angle = angle < 0.0 ? Math.PI * 2 + angle - this.currentAngle : angle - this.currentAngle;
            return angle < 0.0 ? Math.PI * 2 : angle;
        }

        Point2dImpl getIntersection(Caliper that) {
            double x = this.isVertical() ? (double)((Point2d)this.convexHull.points.get(this.pointIndex)).getX() : (this.isHorizontal() ? (double)((Point2d)that.convexHull.points.get(that.pointIndex)).getX() : (that.getConstant() - this.getConstant()) / (this.getSlope() - that.getSlope()));
            double y = this.isVertical() ? that.getConstant() : (this.isHorizontal() ? this.getConstant() : this.getSlope() * x + this.getConstant());
            return new Point2dImpl(x, y);
        }

        double getSlope() {
            return Math.tan(this.currentAngle);
        }

        boolean isHorizontal() {
            return Math.abs(this.currentAngle) < 1.0E-11 || Math.abs(this.currentAngle - Math.PI) < 1.0E-11;
        }

        boolean isVertical() {
            return Math.abs(this.currentAngle - 1.5707963267948966) < 1.0E-11 || Math.abs(this.currentAngle - 4.71238898038469) < 1.0E-11;
        }

        void rotateBy(double angle) {
            if (this.getDeltaAngleNextPoint() == angle) {
                ++this.pointIndex;
            }
            this.currentAngle += angle;
        }
    }

    protected static enum Corner {
        UPPER_RIGHT,
        UPPER_LEFT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }
}

