/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape;

import Jama.Matrix;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;

public class RotatedRectangle
implements Shape,
Cloneable {
    public float width;
    public float height;
    public float rotation;
    public float cx;
    public float cy;

    public RotatedRectangle(Rectangle regRect, float rotation) {
        this.width = regRect.width;
        this.height = regRect.height;
        this.cx = regRect.x + regRect.width / 2.0f;
        this.cy = regRect.y + regRect.height / 2.0f;
        this.rotation = rotation;
    }

    public RotatedRectangle(double x, double y, double width, double height, double rotation) {
        this.cx = (float)x;
        this.cy = (float)y;
        this.width = (float)width;
        this.height = (float)height;
        this.rotation = (float)rotation;
    }

    public RotatedRectangle(float x, float y, float width, float height, float rotation) {
        this.cx = x;
        this.cy = y;
        this.width = width;
        this.height = height;
        this.rotation = rotation;
    }

    @Override
    public Rectangle calculateRegularBoundingBox() {
        return this.asPolygon().calculateRegularBoundingBox();
    }

    @Override
    public void translate(float x, float y) {
        this.cx += x;
        this.cy += y;
    }

    @Override
    public void scale(float sc) {
        this.cx *= sc;
        this.cy *= sc;
        this.width *= sc;
        this.height *= sc;
    }

    @Override
    public void scale(Point2d centre, float sc) {
        this.translate(-centre.getX(), -centre.getY());
        this.scale(sc);
        this.translate(centre.getX(), centre.getY());
    }

    @Override
    public void scaleCentroid(float sc) {
        this.scale(this.calculateCentroid(), sc);
    }

    @Override
    public Point2d calculateCentroid() {
        return new Point2dImpl(this.cx, this.cy);
    }

    @Override
    public double minX() {
        return this.asPolygon().minX();
    }

    @Override
    public double minY() {
        return this.asPolygon().minY();
    }

    @Override
    public double maxX() {
        return this.asPolygon().maxX();
    }

    @Override
    public double maxY() {
        return this.asPolygon().maxY();
    }

    @Override
    public double getWidth() {
        return this.asPolygon().getWidth();
    }

    @Override
    public double getHeight() {
        return this.asPolygon().getHeight();
    }

    @Override
    public boolean isInside(Point2d point) {
        return this.asPolygon().isInside(point);
    }

    @Override
    public double calculateArea() {
        return this.width * this.height;
    }

    @Override
    public double calculatePerimeter() {
        return 2.0f * (this.width + this.height);
    }

    @Override
    public Polygon asPolygon() {
        float b = (float)Math.cos(this.rotation) * 0.5f;
        float a = (float)Math.sin(this.rotation) * 0.5f;
        Point2d[] pts = new Point2dImpl[4];
        pts[0] = new Point2dImpl();
        pts[0].x = this.cx - a * this.height - b * this.width;
        pts[0].y = this.cy + b * this.height - a * this.width;
        pts[1] = new Point2dImpl();
        pts[1].x = this.cx + a * this.height - b * this.width;
        pts[1].y = this.cy - b * this.height - a * this.width;
        pts[2] = new Point2dImpl();
        pts[2].x = 2.0f * this.cx - pts[0].x;
        pts[2].y = 2.0f * this.cy - pts[0].y;
        pts[3] = new Point2dImpl();
        pts[3].x = 2.0f * this.cx - pts[1].x;
        pts[3].y = 2.0f * this.cy - pts[1].y;
        return new Polygon(pts);
    }

    @Override
    public double intersectionArea(Shape that) {
        return this.asPolygon().intersectionArea(that);
    }

    @Override
    public double intersectionArea(Shape that, int nStepsPerDimension) {
        return this.asPolygon().intersectionArea(that, nStepsPerDimension);
    }

    @Override
    public Shape transform(Matrix transform) {
        return this.asPolygon().transform(transform);
    }

    @Override
    public RotatedRectangle minimumBoundingRectangle() {
        return this.clone();
    }

    @Override
    public RotatedRectangle clone() {
        try {
            return (RotatedRectangle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.format("RotatedRect[angle=%2.2f, cx=%2.2f, cy=%2.2f, width=%2.2f, height=%2.2f]", Float.valueOf(this.rotation), Float.valueOf(this.cx), Float.valueOf(this.cy), Float.valueOf(this.width), Float.valueOf(this.height));
    }

    @Override
    public boolean isConvex() {
        return true;
    }
}

