/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.point;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openimaj.math.geometry.GeometricObject2d;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.point.PointListConnections;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.util.GrahamScan;

public class PointList
implements GeometricObject2d,
Iterable<Point2d>,
Cloneable {
    public List<Point2d> points = new ArrayList<Point2d>();

    public PointList(Point2d ... points) {
        for (Point2d v : points) {
            this.points.add(v);
        }
    }

    public PointList(Collection<? extends Point2d> points) {
        this(points, false);
    }

    public PointList(Collection<? extends Point2d> points, boolean copy) {
        if (!copy) {
            this.points.addAll(points);
        } else {
            for (Point2d point2d : points) {
                this.points.add(point2d.copy());
            }
        }
    }

    void rotate(Point2d point, Point2d origin, double angle) {
        double X = (double)origin.getX() + ((double)(point.getX() - origin.getX()) * Math.cos(angle) - (double)(point.getY() - origin.getY()) * Math.sin(angle));
        double Y = (double)origin.getY() + ((double)(point.getX() - origin.getX()) * Math.sin(angle) + (double)(point.getY() - origin.getY()) * Math.cos(angle));
        point.setX((float)X);
        point.setY((float)Y);
    }

    public void rotate(Point2d origin, double angle) {
        for (Point2d p : this.points) {
            this.rotate(p, origin, angle);
        }
    }

    public void rotate(double angle) {
        this.rotate(new Point2dImpl(0.0f, 0.0f), angle);
    }

    @Override
    public Rectangle calculateRegularBoundingBox() {
        int xmin = Integer.MAX_VALUE;
        int xmax = 0;
        int ymin = Integer.MAX_VALUE;
        int ymax = 0;
        for (Point2d p : this.points) {
            if (p.getX() < (float)xmin) {
                xmin = (int)Math.floor(p.getX());
            }
            if (p.getX() > (float)xmax) {
                xmax = (int)Math.ceil(p.getX());
            }
            if (p.getY() < (float)ymin) {
                ymin = (int)Math.floor(p.getY());
            }
            if (!(p.getY() > (float)ymax)) continue;
            ymax = (int)Math.ceil(p.getY());
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    @Override
    public void translate(float x, float y) {
        for (Point2d p : this.points) {
            p.setX(p.getX() + x);
            p.setY(p.getY() + y);
        }
    }

    @Override
    public void scale(float sc) {
        for (Point2d p : this.points) {
            p.setX(p.getX() * sc);
            p.setY(p.getY() * sc);
        }
    }

    public PointList scaleX(float sc) {
        for (Point2d p : this.points) {
            p.setX(p.getX() * sc);
        }
        return this;
    }

    public PointList scaleY(float sc) {
        for (Point2d p : this.points) {
            p.setY(p.getY() * sc);
        }
        return this;
    }

    public PointList scaleXY(float scx, float scy) {
        for (Point2d p : this.points) {
            p.setX(p.getX() * scx);
            p.setY(p.getY() * scy);
        }
        return this;
    }

    @Override
    public void scale(Point2d centre, float sc) {
        this.translate(-centre.getX(), -centre.getY());
        for (Point2d p : this.points) {
            p.setX(p.getX() * sc);
            p.setY(p.getY() * sc);
        }
        this.translate(centre.getX(), centre.getY());
    }

    @Override
    public void scaleCentroid(float sc) {
        Point2d cog = this.calculateCentroid();
        this.translate(-cog.getX(), -cog.getY());
        this.scale(sc);
        this.translate(cog.getX(), cog.getY());
    }

    @Override
    public Point2d calculateCentroid() {
        float xSum = 0.0f;
        float ySum = 0.0f;
        int n = 0;
        for (Point2d p : this.points) {
            xSum += p.getX();
            ySum += p.getY();
            ++n;
        }
        return new Point2dImpl(xSum /= (float)n, ySum /= (float)n);
    }

    @Override
    public double minX() {
        return this.calculateRegularBoundingBox().x;
    }

    @Override
    public double minY() {
        return this.calculateRegularBoundingBox().y;
    }

    @Override
    public double maxX() {
        Rectangle r = this.calculateRegularBoundingBox();
        return r.x + r.width;
    }

    @Override
    public double maxY() {
        Rectangle r = this.calculateRegularBoundingBox();
        return r.y + r.height;
    }

    @Override
    public double getWidth() {
        return this.maxX() - this.minX();
    }

    @Override
    public double getHeight() {
        return this.maxY() - this.minY();
    }

    @Override
    public PointList transform(Matrix transform) {
        ArrayList<Point2dImpl> newVertices = new ArrayList<Point2dImpl>();
        for (Point2d p : this.points) {
            Matrix p1 = new Matrix(3, 1);
            p1.set(0, 0, (double)p.getX());
            p1.set(1, 0, (double)p.getY());
            p1.set(2, 0, 1.0);
            Matrix p2_est = transform.times(p1);
            Point2dImpl out = new Point2dImpl((float)(p2_est.get(0, 0) / p2_est.get(2, 0)), (float)(p2_est.get(1, 0) / p2_est.get(2, 0)));
            newVertices.add(out);
        }
        return new PointList(newVertices);
    }

    @Override
    public Iterator<Point2d> iterator() {
        return this.points.iterator();
    }

    public String toString() {
        return this.points.toString();
    }

    public static PointList computeMean(Collection<PointList> shapes) {
        int npoints = shapes.iterator().next().points.size();
        PointList mean = new PointList(new Point2d[0]);
        for (int i = 0; i < npoints; ++i) {
            mean.points.add(new Point2dImpl());
        }
        for (PointList shape : shapes) {
            for (int i = 0; i < npoints; ++i) {
                Point2dImpl pt = (Point2dImpl)mean.points.get(i);
                pt.x += shape.points.get(i).getX();
                pt.y += shape.points.get(i).getY();
            }
        }
        for (int i = 0; i < npoints; ++i) {
            Point2dImpl pt = (Point2dImpl)mean.points.get(i);
            pt.x /= (float)shapes.size();
            pt.y /= (float)shapes.size();
        }
        return mean;
    }

    public int size() {
        return this.points.size();
    }

    public float computeIntrinsicScale() {
        Point2d cog = this.calculateCentroid();
        float scale = 0.0f;
        for (Point2d pt : this) {
            double x = pt.getX() - cog.getX();
            double y = pt.getY() - cog.getY();
            scale = (float)((double)scale + (x * x + y * y));
        }
        return (float)Math.sqrt(scale / (float)this.points.size());
    }

    public Point2d get(int i) {
        return this.points.get(i);
    }

    public List<Line2d> getLines() {
        ArrayList<Line2d> lines = new ArrayList<Line2d>(this.points.size() - 1);
        for (int i = 1; i < this.points.size(); ++i) {
            lines.add(new Line2d(this.points.get(i - 1), this.points.get(i)));
        }
        return lines;
    }

    public List<Line2d> getLines(PointListConnections conns) {
        return conns.getLines(this);
    }

    public PointList clone() {
        PointList p = new PointList(new Point2d[0]);
        for (Point2d point2d : this) {
            p.points.add(point2d.copy());
        }
        return p;
    }

    public Polygon calculateConvexHull() {
        return GrahamScan.getConvexHull(this.points);
    }
}

