/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class MLSparse
extends MLNumericArray<Double> {
    int nzmax;
    private SortedSet<IndexMN> indexSet;
    private SortedMap<IndexMN, Double> real;
    private SortedMap<IndexMN, Double> imaginary;

    public MLSparse(String name, int[] dims, int attributes, int nzmax) {
        super(name, dims, 5, attributes);
        this.nzmax = nzmax;
    }

    @Override
    protected void allocate() {
        this.real = new TreeMap<IndexMN, Double>();
        if (this.isComplex()) {
            this.imaginary = new TreeMap<IndexMN, Double>();
        }
        this.indexSet = new TreeSet<IndexMN>();
    }

    public int getMaxNZ() {
        return this.nzmax;
    }

    public int[] getIR() {
        int[] ir = new int[this.nzmax];
        int i = 0;
        for (IndexMN index : this.indexSet) {
            ir[i++] = index.m;
        }
        return ir;
    }

    public int[] getIC() {
        int[] ic = new int[this.nzmax];
        int i = 0;
        for (IndexMN index : this.indexSet) {
            ic[i++] = index.n;
        }
        return ic;
    }

    public int[] getJC() {
        int[] jc = new int[this.getN() + 1];
        for (IndexMN index : this.indexSet) {
            int column = index.n + 1;
            while (column < jc.length) {
                int n = column++;
                jc[n] = jc[n] + 1;
            }
        }
        return jc;
    }

    public Double[] createArray(int m, int n) {
        return null;
    }

    @Override
    public Double getReal(int m, int n) {
        IndexMN i = new IndexMN(m, n);
        if (this.real.containsKey(i)) {
            return (Double)this.real.get(i);
        }
        return new Double(0.0);
    }

    @Override
    public Double getReal(int index) {
        throw new IllegalArgumentException("Can't get Sparse array elements by index. Please use getReal(int index) instead.");
    }

    @Override
    public void setReal(Double value, int m, int n) {
        IndexMN i = new IndexMN(m, n);
        this.indexSet.add(i);
        this.real.put(i, value);
    }

    @Override
    public void setReal(Double value, int index) {
        throw new IllegalArgumentException("Can't set Sparse array elements by index. Please use setReal(Double value, int m, int n) instead.");
    }

    @Override
    public void setImaginary(Double value, int m, int n) {
        IndexMN i = new IndexMN(m, n);
        this.indexSet.add(i);
        this.imaginary.put(i, value);
    }

    @Override
    public void setImaginary(Double value, int index) {
        throw new IllegalArgumentException("Can't set Sparse array elements by index. Please use setImaginary(Double value, int m, int n) instead.");
    }

    @Override
    public Double getImaginary(int m, int n) {
        IndexMN i = new IndexMN(m, n);
        if (this.imaginary.containsKey(i)) {
            return (Double)this.imaginary.get(i);
        }
        return new Double(0.0);
    }

    @Override
    public Double getImaginary(int index) {
        throw new IllegalArgumentException("Can't get Sparse array elements by index. Please use getImaginary(int index) instead.");
    }

    public Double[] exportReal() {
        Double[] ad = new Double[this.indexSet.size()];
        int i = 0;
        for (IndexMN index : this.indexSet) {
            ad[i] = this.real.containsKey(index) ? (Double)this.real.get(index) : Double.valueOf(0.0);
            ++i;
        }
        return ad;
    }

    public Double[] exportImaginary() {
        Double[] ad = new Double[this.indexSet.size()];
        int i = 0;
        for (IndexMN index : this.indexSet) {
            ad[i] = this.imaginary.containsKey(index) ? (Double)this.imaginary.get(index) : Double.valueOf(0.0);
            ++i;
        }
        return ad;
    }

    @Override
    public String contentToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + " = \n");
        for (IndexMN i : this.indexSet) {
            sb.append("\t(");
            sb.append(String.valueOf(i.m) + "," + i.n);
            sb.append(")");
            sb.append("\t" + this.getReal(i.m, i.n));
            if (this.isComplex()) {
                sb.append("+" + this.getImaginary(i.m, i.n));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public int getBytesAllocated() {
        return 512;
    }

    @Override
    public Double buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(bytes).getDouble();
    }

    @Override
    public byte[] getByteArray(Double value) {
        int byteAllocated = this.getBytesAllocated();
        ByteBuffer buff = ByteBuffer.allocate(byteAllocated);
        buff.putDouble(value);
        return buff.array();
    }

    @Override
    public Class<Double> getStorageClazz() {
        return Double.class;
    }

    private class IndexMN
    implements Comparable<IndexMN> {
        int m;
        int n;

        public IndexMN(int m, int n) {
            this.m = m;
            this.n = n;
        }

        @Override
        public int compareTo(IndexMN anOtherIndex) {
            return MLSparse.this.getIndex(this.m, this.n) - MLSparse.this.getIndex(anOtherIndex.m, anOtherIndex.n);
        }

        public boolean equals(Object o) {
            if (o instanceof IndexMN) {
                return this.m == ((IndexMN)o).m && this.n == ((IndexMN)o).n;
            }
            return super.equals(o);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            sb.append("m=" + this.m);
            sb.append(", ");
            sb.append("n=" + this.n);
            sb.append("}");
            return sb.toString();
        }
    }
}

