/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.ByteStorageSupport;
import com.jmatio.types.GenericArrayCreator;
import com.jmatio.types.MLArray;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class MLNumericArray<T extends Number>
extends MLArray
implements GenericArrayCreator<T>,
ByteStorageSupport<T> {
    private ByteBuffer real;
    private ByteBuffer imaginary;
    private byte[] bytes;

    public MLNumericArray(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
        this.allocate();
    }

    protected void allocate() {
        this.real = ByteBuffer.allocate(this.getSize() * this.getBytesAllocated());
        if (this.isComplex()) {
            this.imaginary = ByteBuffer.allocate(this.getSize() * this.getBytesAllocated());
        }
        this.bytes = new byte[this.getBytesAllocated()];
    }

    public MLNumericArray(String name, int type, T[] vals, int m) {
        this(name, new int[]{m, vals.length / m}, type, 0);
        int i = 0;
        while (i < vals.length) {
            this.set(vals[i], i);
            ++i;
        }
    }

    public T getReal(int m, int n) {
        return this.getReal(this.getIndex(m, n));
    }

    public T getReal(int index) {
        return this._get(this.real, index);
    }

    public void setReal(T value, int m, int n) {
        this.setReal(value, this.getIndex(m, n));
    }

    public void setReal(T value, int index) {
        this._set(this.real, value, index);
    }

    public void setReal(T[] vector) {
        if (vector.length != this.getSize()) {
            throw new IllegalArgumentException("Matrix dimensions do not match. " + this.getSize() + " not " + vector.length);
        }
        System.arraycopy(vector, 0, this.real, 0, vector.length);
    }

    public void setImaginary(T value, int m, int n) {
        this.setImaginary(value, this.getIndex(m, n));
    }

    public void setImaginary(T value, int index) {
        if (this.isComplex()) {
            this._set(this.imaginary, value, index);
        }
    }

    public T getImaginary(int m, int n) {
        return this.getImaginary(this.getIndex(m, n));
    }

    public T getImaginary(int index) {
        return this._get(this.imaginary, index);
    }

    public void set(T value, int m, int n) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        this.setReal(value, m, n);
    }

    public void set(T value, int index) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        this.setReal(value, index);
    }

    public T get(int m, int n) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        return this.getReal(m, n);
    }

    public T get(int index) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        return this._get(this.real, index);
    }

    public void set(T[] vector) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        this.setReal((Number[])vector);
    }

    private int getByteOffset(int index) {
        return index * this.getBytesAllocated();
    }

    protected T _get(ByteBuffer buffer, int index) {
        buffer.position(this.getByteOffset(index));
        buffer.get(this.bytes, 0, this.bytes.length);
        return this.buldFromBytes(this.bytes);
    }

    protected void _set(ByteBuffer buffer, T value, int index) {
        buffer.position(this.getByteOffset(index));
        buffer.put(this.getByteArray(value));
    }

    public void putImaginaryByteBuffer(ByteBuffer buff) {
        if (!this.isComplex()) {
            throw new RuntimeException("Array is not complex");
        }
        this.imaginary.rewind();
        this.imaginary.put(buff);
    }

    public ByteBuffer getImaginaryByteBuffer() {
        return this.imaginary;
    }

    public void putRealByteBuffer(ByteBuffer buff) {
        this.real.rewind();
        this.real.put(buff);
    }

    public ByteBuffer getRealByteBuffer() {
        return this.real;
    }

    @Override
    public String contentToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + " = \n");
        if (this.getSize() > 1000) {
            sb.append("Cannot display variables with more than 1000 elements.");
            return sb.toString();
        }
        int m = 0;
        while (m < this.getM()) {
            sb.append("\t");
            int n = 0;
            while (n < this.getN()) {
                sb.append(this.getReal(m, n));
                if (this.isComplex()) {
                    sb.append("+" + this.getImaginary(m, n));
                }
                sb.append("\t");
                ++n;
            }
            sb.append("\n");
            ++m;
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof MLNumericArray) {
            boolean result;
            boolean bl = result = MLNumericArray.directByteBufferEquals(this.real, ((MLNumericArray)o).real) && Arrays.equals(this.dims, ((MLNumericArray)o).dims);
            if (this.isComplex() && result) {
                result &= MLNumericArray.directByteBufferEquals(this.imaginary, ((MLNumericArray)o).imaginary);
            }
            return result;
        }
        return super.equals(o);
    }

    private static boolean directByteBufferEquals(ByteBuffer buffa, ByteBuffer buffb) {
        if (buffa == buffb) {
            return true;
        }
        if (buffa == null || buffb == null) {
            return false;
        }
        buffa.rewind();
        buffb.rewind();
        int length = buffa.remaining();
        if (buffb.remaining() != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (buffa.get() != buffb.get()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void dispose() {
        if (this.real != null) {
            this.real.clear();
        }
        if (this.imaginary != null) {
            this.real.clear();
        }
    }
}

