/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;

public class MLDouble
extends MLNumericArray<Double> {
    public MLDouble(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLDouble(String name, int[] dims) {
        super(name, dims, 6, 0);
    }

    public MLDouble(String name, Double[] vals, int m) {
        super(name, 6, (Number[])vals, m);
    }

    public MLDouble(String name, double[][] vals) {
        this(name, MLDouble.double2DToDouble(vals), vals.length);
    }

    public MLDouble(String name, double[] vals, int m) {
        this(name, MLDouble.castToDouble(vals), m);
    }

    public Double[] createArray(int m, int n) {
        return new Double[m * n];
    }

    public double[][] getArray() {
        double[][] result = new double[this.getM()][];
        int m = 0;
        while (m < this.getM()) {
            result[m] = new double[this.getN()];
            int n = 0;
            while (n < this.getN()) {
                result[m][n] = (Double)this.getReal(m, n);
                ++n;
            }
            ++m;
        }
        return result;
    }

    private static Double[] castToDouble(double[] d) {
        Double[] dest = new Double[d.length];
        int i = 0;
        while (i < d.length) {
            dest[i] = d[i];
            ++i;
        }
        return dest;
    }

    private static Double[] double2DToDouble(double[][] dd) {
        Double[] d = new Double[dd.length * dd[0].length];
        int n = 0;
        while (n < dd[0].length) {
            int m = 0;
            while (m < dd.length) {
                d[m + n * dd.length] = dd[m][n];
                ++m;
            }
            ++n;
        }
        return d;
    }

    @Override
    public int getBytesAllocated() {
        return 8;
    }

    @Override
    public Double buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(bytes).getDouble();
    }

    @Override
    public byte[] getByteArray(Double value) {
        int byteAllocated = this.getBytesAllocated();
        ByteBuffer buff = ByteBuffer.allocate(byteAllocated);
        buff.putDouble(value);
        return buff.array();
    }

    @Override
    public Class<Double> getStorageClazz() {
        return Double.class;
    }
}

