/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.GenericArrayCreator;
import com.jmatio.types.MLArray;
import java.util.Arrays;

public class MLChar
extends MLArray
implements GenericArrayCreator<Character> {
    Character[] chars = this.createArray(this.getM(), this.getN());

    public MLChar(String name, String value) {
        this(name, new int[]{1, value.length()}, 4, 0);
        this.set(value);
    }

    public MLChar(String name, String[] values) {
        this(name, new int[]{values.length, values.length > 0 ? MLChar.getMaxLength(values) : 0}, 4, 0);
        int i = 0;
        while (i < values.length) {
            this.set(values[i], i);
            ++i;
        }
    }

    private static int getMaxLength(String[] values) {
        int result = 0;
        int i = 0;
        int curr = 0;
        while (i < values.length) {
            curr = values[i].length();
            if (curr > result) {
                result = curr;
            }
            ++i;
        }
        return result;
    }

    public MLChar(String name, String[] values, int maxlen) {
        this(name, new int[]{values.length, maxlen}, 4, 0);
        int idx = 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            this.set(v, idx);
            ++idx;
            ++n2;
        }
    }

    public MLChar(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public Character[] createArray(int m, int n) {
        return new Character[m * n];
    }

    public void setChar(char ch, int index) {
        this.chars[index] = Character.valueOf(ch);
    }

    public void set(String value) {
        char[] cha = value.toCharArray();
        int i = 0;
        while (i < this.getN() && i < value.length()) {
            this.setChar(cha[i], i);
            ++i;
        }
    }

    public void set(String value, int idx) {
        int rowOffset = this.getM();
        int i = 0;
        while (i < this.getN()) {
            if (i < value.length()) {
                this.setChar(value.charAt(i), idx + rowOffset * i);
            } else {
                this.setChar(' ', idx + rowOffset * i);
            }
            ++i;
        }
    }

    public Character getChar(int m, int n) {
        return this.chars[this.getIndex(m, n)];
    }

    public Character[] exportChar() {
        return this.chars;
    }

    public boolean equals(Object o) {
        if (o instanceof MLChar) {
            return Arrays.equals((Object[])this.chars, (Object[])((MLChar)o).chars);
        }
        return super.equals(o);
    }

    public String getString(int m) {
        StringBuffer charbuff = new StringBuffer();
        int n = 0;
        while (n < this.getN()) {
            charbuff.append(this.getChar(m, n));
            ++n;
        }
        return charbuff.toString().trim();
    }

    @Override
    public String contentToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + " = \n");
        int m = 0;
        while (m < this.getM()) {
            sb.append("\t");
            StringBuffer charbuff = new StringBuffer();
            charbuff.append("'");
            int n = 0;
            while (n < this.getN()) {
                charbuff.append(this.getChar(m, n));
                ++n;
            }
            charbuff.append("'");
            sb.append(charbuff);
            sb.append("\n");
            ++m;
        }
        return sb.toString();
    }
}

