/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.pgm.vb.lda.mle;

import org.openimaj.pgm.util.Corpus;

public class LDAModel {
    public double alpha;
    public double[][] topicWord;
    public double[] topicTotal;
    public int ntopics;
    int iteration;
    double likelihood;
    double oldLikelihood;

    public LDAModel(int ntopics) {
        this.ntopics = ntopics;
    }

    public void prepare(Corpus corpus) {
        this.topicWord = new double[this.ntopics][corpus.vocabularySize()];
        this.topicTotal = new double[this.ntopics];
        this.alpha = 0.0;
        this.iteration = 0;
        this.likelihood = 0.0;
        this.oldLikelihood = Double.NEGATIVE_INFINITY;
    }

    public void prepare(int vocabularySize) {
        this.topicWord = new double[this.ntopics][vocabularySize];
        this.topicTotal = new double[this.ntopics];
        this.alpha = 0.0;
    }

    public void incTopicWord(int topicIndex, int wordIndex, double d) {
        double[] dArray = this.topicWord[topicIndex];
        int n = wordIndex;
        dArray[n] = dArray[n] + d;
    }

    public void incTopicTotal(int topicIndex, double d) {
        int n = topicIndex;
        this.topicTotal[n] = this.topicTotal[n] + d;
    }

    public void setAlpha(double initialAlpha) {
        this.alpha = initialAlpha;
    }

    public LDAModel newInstance() {
        LDAModel ret = new LDAModel(this.ntopics);
        ret.prepare(this.topicWord[0].length);
        ret.iteration = this.iteration;
        ret.likelihood = 0.0;
        ret.oldLikelihood = this.likelihood;
        return ret;
    }
}

