/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.processor;

import java.util.ArrayList;
import java.util.Iterator;
import org.openimaj.ml.regression.LinearRegression;
import org.openimaj.ml.timeseries.processor.TimeSeriesProcessor;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;
import org.openimaj.util.pair.IndependentPair;

public class WindowedLinearRegressionProcessor
implements TimeSeriesProcessor<double[], Double, DoubleTimeSeries> {
    private static final int DEFAULT_WINDOW_SIZE = 3;
    private static final int DEFAULT_OFFSET = 1;
    private LinearRegression reg;
    private boolean regdefined;
    private int windowsize;
    private int offset;

    public WindowedLinearRegressionProcessor() {
        this.windowsize = 3;
        this.offset = 1;
        this.regdefined = false;
    }

    public WindowedLinearRegressionProcessor(int windowsize) {
        this.windowsize = windowsize;
        this.offset = 1;
        this.regdefined = false;
    }

    public WindowedLinearRegressionProcessor(int windowsize, int offset) {
        this.windowsize = windowsize;
        this.offset = offset;
        this.regdefined = false;
    }

    public WindowedLinearRegressionProcessor(LinearRegression reg) {
        this.reg = reg;
        this.regdefined = true;
    }

    public WindowedLinearRegressionProcessor(DoubleTimeSeries yearFirstHalf, int i) {
        WindowedLinearRegressionProcessor inner = new WindowedLinearRegressionProcessor(i);
        inner.process(yearFirstHalf);
        this.reg = inner.reg;
        this.windowsize = i;
        this.regdefined = true;
    }

    public WindowedLinearRegressionProcessor(DoubleTimeSeries yearFirstHalf, int windowsize, int offset) {
        WindowedLinearRegressionProcessor inner = new WindowedLinearRegressionProcessor(windowsize, offset);
        inner.process(yearFirstHalf);
        this.reg = inner.reg;
        this.windowsize = windowsize;
        this.offset = offset;
        this.regdefined = true;
    }

    @Override
    public void process(DoubleTimeSeries series) {
        ArrayList<IndependentPair> instances = new ArrayList<IndependentPair>();
        double[] data = series.getData();
        for (int i = this.windowsize + (this.offset - 1); i < series.size(); ++i) {
            int start = i - this.windowsize - (this.offset - 1);
            double[] datawindow = new double[this.windowsize];
            System.arraycopy(data, start, datawindow, 0, this.windowsize);
            instances.add(IndependentPair.pair((Object)datawindow, (Object)new double[]{data[i]}));
        }
        if (!this.regdefined) {
            this.reg = new LinearRegression();
            this.reg.estimate(instances);
        }
        System.out.println(this.reg);
        Iterator instanceIter = instances.iterator();
        for (int i = this.windowsize + (this.offset - 1); i < series.size(); ++i) {
            data[i] = this.reg.predict((double[])((IndependentPair)instanceIter.next()).firstObject())[0];
        }
        long[] times = series.getTimes();
        long begin = times[this.windowsize + (this.offset - 1)];
        long end = times[times.length - 1];
        series.internalAssign(series.get(begin, end));
    }

    public void holdreg(boolean regdefined) {
        this.regdefined = regdefined;
    }

    public LinearRegression getRegression() {
        return this.reg;
    }
}

