/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.aggregator;

import Jama.Matrix;
import org.openimaj.math.matrix.MatrixUtils;
import org.openimaj.ml.timeseries.aggregator.SynchronisedTimeSeriesCollectionAggregator;
import org.openimaj.ml.timeseries.series.DoubleSynchronisedTimeSeriesCollection;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;

public class SquaredSummedDifferenceAggregator
implements SynchronisedTimeSeriesCollectionAggregator<DoubleTimeSeries, DoubleSynchronisedTimeSeriesCollection, Double> {
    @Override
    public Double aggregate(DoubleSynchronisedTimeSeriesCollection series) {
        Matrix squarediffs = null;
        for (DoubleTimeSeries ds : series.allseries()) {
            if (squarediffs == null) {
                squarediffs = new Matrix((double[][])new double[][]{ds.getData()});
                continue;
            }
            squarediffs = squarediffs.minus(new Matrix((double[][])new double[][]{ds.getData()}));
            squarediffs = squarediffs.arrayTimes(squarediffs);
        }
        return MatrixUtils.sum(squarediffs);
    }
}

