/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.perceptron;

import ch.akuhn.matrix.DenseMatrix;
import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.Vector;
import org.openimaj.math.matrix.MatlibMatrixUtils;
import org.openimaj.ml.linear.kernel.VectorKernel;
import org.openimaj.ml.linear.learner.perceptron.DoubleArrayKernelPerceptron;
import org.openimaj.ml.linear.learner.perceptron.PerceptronClass;
import org.openimaj.util.pair.IndependentPair;

public class Projectron
extends DoubleArrayKernelPerceptron {
    private static final double DEFAULT_ETA = (double)0.01f;
    private Matrix Kinv;
    private double eta;

    public Projectron(VectorKernel kernel, double eta) {
        super(kernel);
        this.eta = eta;
        this.Kinv = DenseMatrix.dense((int)0, (int)0);
    }

    public Projectron(VectorKernel kernel) {
        this(kernel, 0.01f);
    }

    @Override
    public void update(double[] xt, PerceptronClass yt, PerceptronClass yt_prime) {
        Vector kt;
        Vector d_optimal;
        double kii = (Double)this.kernel.apply(IndependentPair.pair((Object)xt, (Object)xt));
        double delta = Math.max(kii - (d_optimal = this.Kinv.mult(kt = this.calculatekt(xt))).dot(kt), 0.0);
        if (delta <= this.eta) {
            this.updateWeights(yt, d_optimal);
        } else {
            super.update(xt, yt, yt_prime);
            this.updateKinv(d_optimal, delta);
        }
    }

    private void updateWeights(PerceptronClass y, Vector d_optimal) {
        for (int i = 0; i < d_optimal.size(); ++i) {
            this.weights.set(i, (Double)this.weights.get(i) + (double)y.v() * d_optimal.get(i));
        }
    }

    @Override
    public double getBias() {
        return 0.0;
    }

    private void updateKinv(Vector d_optimal, double delta) {
        Matrix newKinv = null;
        if (this.supports.size() > 1) {
            Vector expandD = Vector.dense((int)(d_optimal.size() + 1));
            Matrix expandDMat = DenseMatrix.dense((int)expandD.size(), (int)1);
            MatlibMatrixUtils.setSubVector((Vector)expandDMat.column(0), (int)0, (Vector)d_optimal);
            expandDMat.column(0).put(d_optimal.size(), -1.0);
            newKinv = new DenseMatrix(this.Kinv.rowCount() + 1, this.Kinv.columnCount() + 1);
            MatlibMatrixUtils.setSubMatrix((Matrix)newKinv, (int)0, (int)0, (Matrix)this.Kinv);
            Matrix expandDMult = newKinv.newInstance();
            MatlibMatrixUtils.dotProductTranspose((Matrix)expandDMat, (Matrix)expandDMat, (Matrix)expandDMult);
            MatlibMatrixUtils.scaleInplace((Matrix)expandDMult, (double)(1.0 / delta));
            MatlibMatrixUtils.plusInplace((Matrix)newKinv, (Matrix)expandDMult);
        } else {
            double[] only = (double[])this.supports.get(0);
            newKinv = DenseMatrix.dense((int)1, (int)1);
            newKinv.put(0, 0, 1.0 / (Double)this.kernel.apply(IndependentPair.pair((Object)only, (Object)only)));
        }
        this.Kinv = newKinv;
    }

    private Vector calculatekt(double[] xt) {
        Vector ret = Vector.dense((int)this.supports.size());
        for (int i = 0; i < this.supports.size(); ++i) {
            ret.put(i, ((Double)this.kernel.apply(IndependentPair.pair((Object)xt, this.supports.get(i)))).doubleValue());
        }
        return ret;
    }
}

