/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.perceptron;

import Jama.Matrix;
import ch.akuhn.matrix.DenseMatrix;
import ch.akuhn.matrix.DenseVector;
import ch.akuhn.matrix.Vector;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.math.matrix.MatlibMatrixUtils;
import org.openimaj.ml.linear.kernel.Kernel;
import org.openimaj.ml.linear.learner.OnlineLearner;
import org.openimaj.ml.linear.learner.perceptron.PerceptronClass;
import org.openimaj.util.pair.IndependentPair;

@References(references={@Reference(type=ReferenceType.Article, author={"Francesco Orabona", "Claudio Castellini", "Barbara Caputo", "Luo Jie", "Giulio Sandini"}, title="On-line independent support vector machines", year="2010", journal="Pattern Recognition", pages={"1402", "1412"}, number="4", volume="43")})
public class OISVM
implements OnlineLearner<double[], PerceptronClass> {
    private static final int DEFAULT_NEWTON_ITER = 20;
    private Kernel<double[]> kernel;
    protected List<double[]> supports = new ArrayList<double[]>();
    protected TIntArrayList supportIndex = new TIntArrayList();
    private List<PerceptronClass> expected = new ArrayList<PerceptronClass>();
    private ch.akuhn.matrix.Matrix Kinv;
    private ch.akuhn.matrix.Matrix K;
    private double eta;
    private Vector beta;
    int newtonMaxIter = 20;
    double C = 1.0;
    private List<double[]> nonSupports = new ArrayList<double[]>();

    public OISVM(Kernel<double[]> kernel, double eta) {
        this.kernel = kernel;
        this.eta = eta;
        this.K = DenseMatrix.dense((int)0, (int)0);
        this.Kinv = DenseMatrix.dense((int)0, (int)0);
    }

    @Override
    public void process(double[] x, PerceptronClass y) {
        Vector kt;
        Vector k;
        Vector d_optimal;
        double kii = (Double)this.kernel.apply(IndependentPair.pair((Object)x, (Object)x));
        double delta = kii - (d_optimal = this.Kinv.mult(k = (kt = this.calculatekt(x)).times((double)y.v()))).dot(k);
        if (delta > this.eta) {
            this.updateSupports(x, y, k, kii, d_optimal, delta);
        } else {
            this.updateNonSupports(x, y, kt, d_optimal);
        }
        double ot = k.dot(this.beta);
        if (ot < 1.0) {
            TIntArrayList newI;
            int newtonIter = 0;
            TIntArrayList I = new TIntArrayList();
            while (newtonIter++ < this.newtonMaxIter && !(newI = this.newtonStep(I)).equals((Object)I)) {
                I = newI;
            }
        }
    }

    private void updateSupports(double[] x, PerceptronClass y, Vector k, double kii, Vector d_optimal, double delta) {
        this.supports.add(x);
        this.expected.add(y);
        this.supportIndex.add(this.K.columnCount() - 1);
        if (this.supports.size() > 1) {
            this.updateKinv(d_optimal, delta);
            this.updateK(k, kii);
            this.updateBeta();
        } else {
            this.init();
        }
    }

    private void updateNonSupports(double[] x, PerceptronClass y, Vector kk, Vector d_optimal) {
        this.nonSupports.add(d_optimal.unwrap());
        MatlibMatrixUtils.appendColumn((ch.akuhn.matrix.Matrix)this.K, (Vector)kk);
    }

    private TIntArrayList newtonStep(TIntArrayList currentI) {
        TIntArrayList Icols = new TIntArrayList(this.K.rowCount());
        TDoubleArrayList Yvals = new TDoubleArrayList(this.K.rowCount());
        Vector v = this.K.mult(this.beta);
        for (int i = 0; i < this.K.rowCount(); ++i) {
            int yi = this.expected.get(i).v();
            double yioi = v.get(i) * (double)yi;
            if (!(1.0 - yioi > 0.0)) continue;
            Icols.add(i);
            Yvals.add((double)yi);
        }
        if (currentI.equals((Object)Icols)) {
            return Icols;
        }
        ch.akuhn.matrix.Matrix Kbi = MatlibMatrixUtils.subMatrix((ch.akuhn.matrix.Matrix)this.K, (int)0, (int)this.K.rowCount(), (TIntArrayList)Icols);
        Vector g = DenseVector.wrap((double[])Yvals.toArray());
        MatlibMatrixUtils.minusInplace((Vector)g, (Vector)Kbi.mult(this.beta));
        g = Kbi.mult(g);
        g = MatlibMatrixUtils.minus((Vector)v, (Vector)g);
        DenseMatrix P = new DenseMatrix(this.K.rowCount(), this.K.columnCount());
        MatlibMatrixUtils.dotProductTranspose((ch.akuhn.matrix.Matrix)Kbi, (ch.akuhn.matrix.Matrix)Kbi, (ch.akuhn.matrix.Matrix)P);
        MatlibMatrixUtils.scaleInplace((ch.akuhn.matrix.Matrix)P, (double)this.C);
        MatlibMatrixUtils.plusInplace((ch.akuhn.matrix.Matrix)P, (ch.akuhn.matrix.Matrix)this.K);
        ch.akuhn.matrix.Matrix Pinv = MatlibMatrixUtils.fromJama((Matrix)MatlibMatrixUtils.toJama((ch.akuhn.matrix.Matrix)P).inverse());
        MatlibMatrixUtils.minusInplace((Vector)this.beta, (Vector)Pinv.mult(g));
        return Icols;
    }

    @Override
    public PerceptronClass predict(double[] x) {
        return PerceptronClass.fromSign(Math.signum(this.calculatekt(x).dot(this.beta)));
    }

    private void init() {
        double[] only = this.supports.get(0);
        this.K = DenseMatrix.dense((int)1, (int)1);
        this.Kinv = DenseMatrix.dense((int)1, (int)1);
        double kv = (Double)this.kernel.apply(IndependentPair.pair((Object)only, (Object)only));
        this.Kinv.put(0, 0, 1.0 / kv);
        this.K.put(0, 0, kv);
        this.beta = DenseVector.dense((int)1);
    }

    private void updateK(Vector kt, double kii) {
        ch.akuhn.matrix.Matrix newK;
        Vector row = DenseVector.dense((int)this.K.columnCount());
        row.put(this.K.columnCount() - 1, kii);
        this.K = newK = MatlibMatrixUtils.appendRow((ch.akuhn.matrix.Matrix)this.K, (Vector)row);
    }

    private void updateBeta() {
        Vector newB = DenseVector.dense((int)(this.beta.size() + 1));
        MatlibMatrixUtils.setSubVector((Vector)newB, (int)0, (Vector)this.beta);
        this.beta = newB;
    }

    private void updateKinv(Vector d_optimal, double delta) {
        DenseMatrix newKinv = null;
        ch.akuhn.matrix.Matrix expandDMat = DenseMatrix.dense((int)(d_optimal.size() + 1), (int)1);
        MatlibMatrixUtils.setSubVector((Vector)expandDMat.column(0), (int)0, (Vector)d_optimal);
        expandDMat.column(0).put(d_optimal.size(), -1.0);
        newKinv = new DenseMatrix(this.Kinv.rowCount() + 1, this.Kinv.columnCount() + 1);
        MatlibMatrixUtils.setSubMatrix((ch.akuhn.matrix.Matrix)newKinv, (int)0, (int)0, (ch.akuhn.matrix.Matrix)this.Kinv);
        ch.akuhn.matrix.Matrix expandDMult = newKinv.newInstance();
        MatlibMatrixUtils.dotProductTranspose((ch.akuhn.matrix.Matrix)expandDMat, (ch.akuhn.matrix.Matrix)expandDMat, (ch.akuhn.matrix.Matrix)expandDMult);
        MatlibMatrixUtils.scaleInplace((ch.akuhn.matrix.Matrix)expandDMult, (double)(1.0 / delta));
        MatlibMatrixUtils.plusInplace((ch.akuhn.matrix.Matrix)newKinv, (ch.akuhn.matrix.Matrix)expandDMult);
        this.Kinv = newKinv;
    }

    private Vector calculatekt(double[] x) {
        Vector ret = Vector.dense((int)this.supports.size());
        for (int i = 0; i < this.supports.size(); ++i) {
            ret.put(i, ((Double)this.kernel.apply(IndependentPair.pair((Object)x, (Object)this.supports.get(i)))).doubleValue());
        }
        return ret;
    }
}

