/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation.linear;

import gov.sandia.cognition.learning.algorithm.svm.PrimalEstimatedSubGradient;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.feature.FeatureVector;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.BatchAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.ml.annotation.utils.AnnotatedListHelper;

public class LinearSVMAnnotator<OBJECT, ANNOTATION>
extends BatchAnnotator<OBJECT, ANNOTATION> {
    private final Map<ANNOTATION, LinearBinaryCategorizer> classifiers = new HashMap<ANNOTATION, LinearBinaryCategorizer>();
    private Set<ANNOTATION> annotations;
    private ANNOTATION negativeClass;
    private FeatureExtractor<? extends FeatureVector, OBJECT> extractor;

    public LinearSVMAnnotator(FeatureExtractor<? extends FeatureVector, OBJECT> extractor, ANNOTATION negativeClass) {
        this.extractor = extractor;
        this.negativeClass = negativeClass;
    }

    public LinearSVMAnnotator(FeatureExtractor<? extends FeatureVector, OBJECT> extractor) {
        this(extractor, null);
    }

    @Override
    public void train(List<? extends Annotated<OBJECT, ANNOTATION>> data) {
        AnnotatedListHelper<OBJECT, ANNOTATION> helper = new AnnotatedListHelper<OBJECT, ANNOTATION>(data);
        this.annotations = helper.getAnnotations();
        for (ANNOTATION annotation : this.annotations) {
            PrimalEstimatedSubGradient pegasos = new PrimalEstimatedSubGradient();
            List<? extends FeatureVector> positive = helper.extractFeatures(annotation, this.extractor);
            List<? extends FeatureVector> negative = helper.extractFeaturesExclude(annotation, this.extractor);
            pegasos.learn(this.convert(positive, negative));
            this.classifiers.put(annotation, pegasos.getResult());
        }
    }

    private Collection<? extends InputOutputPair<? extends Vectorizable, Boolean>> convert(List<? extends FeatureVector> positive, List<? extends FeatureVector> negative) {
        ArrayList<DefaultInputOutputPair> data = new ArrayList<DefaultInputOutputPair>(positive.size() + negative.size());
        for (FeatureVector featureVector : positive) {
            data.add(new DefaultInputOutputPair((Object)this.convert(featureVector), (Object)true));
        }
        for (FeatureVector featureVector : negative) {
            data.add(new DefaultInputOutputPair((Object)this.convert(featureVector), (Object)false));
        }
        return data;
    }

    @Override
    public Set<ANNOTATION> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT object) {
        ArrayList<ScoredAnnotation<ANNOTATION>> results = new ArrayList<ScoredAnnotation<ANNOTATION>>();
        for (ANNOTATION annotation : this.annotations) {
            if (annotation.equals(this.negativeClass)) continue;
            FeatureVector feature = (FeatureVector)this.extractor.extractFeature(object);
            Vector vector = this.convert(feature);
            double result = this.classifiers.get(annotation).evaluateAsDouble(vector);
            if (!(result > 0.0)) continue;
            results.add(new ScoredAnnotation<ANNOTATION>(annotation, (float)Math.abs(result)));
        }
        return results;
    }

    private Vector convert(FeatureVector feature) {
        return VectorFactory.getDenseDefault().copyArray(feature.asDoubleVector());
    }
}

