/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation.linear;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.feature.FeatureVector;
import org.openimaj.math.matrix.PseudoInverse;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.BatchAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;

@Reference(type=ReferenceType.Inproceedings, author={"Jonathan Hare", "Paul Lewis"}, title="Semantic Retrieval and Automatic Annotation: Linear Transformations, Correlation and Semantic Spaces", year="2010", booktitle="Imaging and Printing in a Web 2.0 World; and Multimedia Content Access: Algorithms and Systems IV", url="http://eprints.soton.ac.uk/268496/", note=" Event Dates: 17-21 Jan 2010", month="January", publisher="SPIE", volume="7540")
public class DenseLinearTransformAnnotator<OBJECT, ANNOTATION>
extends BatchAnnotator<OBJECT, ANNOTATION> {
    protected List<ANNOTATION> terms;
    protected Matrix transform;
    protected int k = 10;
    private FeatureExtractor<? extends FeatureVector, OBJECT> extractor;

    public DenseLinearTransformAnnotator(int k, FeatureExtractor<? extends FeatureVector, OBJECT> extractor) {
        this.extractor = extractor;
        this.k = k;
    }

    @Override
    public void train(List<? extends Annotated<OBJECT, ANNOTATION>> data) {
        HashSet<ANNOTATION> termsSet = new HashSet<ANNOTATION>();
        for (Annotated<OBJECT, ANNOTATION> d : data) {
            termsSet.addAll(d.getAnnotations());
        }
        this.terms = new ArrayList<ANNOTATION>(termsSet);
        int termLen = this.terms.size();
        int trainingLen = data.size();
        Annotated<OBJECT, ANNOTATION> first = data.get(0);
        double[] fv = ((FeatureVector)this.extractor.extractFeature(first.getObject())).asDoubleVector();
        int featureLen = fv.length;
        Matrix F = new Matrix(trainingLen, featureLen);
        Matrix W = new Matrix(trainingLen, termLen);
        this.addRow(F, W, 0, fv, first.getAnnotations());
        for (int i = 1; i < trainingLen; ++i) {
            this.addRow(F, W, i, data.get(i));
        }
        Matrix pinvF = PseudoInverse.pseudoInverse((Matrix)F, (int)this.k);
        this.transform = pinvF.times(W);
    }

    private void addRow(Matrix F, Matrix W, int r, Annotated<OBJECT, ANNOTATION> data) {
        double[] fv = ((FeatureVector)this.extractor.extractFeature(data.getObject())).asDoubleVector();
        this.addRow(F, W, r, fv, data.getAnnotations());
    }

    private void addRow(Matrix F, Matrix W, int r, double[] fv, Collection<ANNOTATION> annotations) {
        for (int j = 0; j < F.getColumnDimension(); ++j) {
            F.getArray()[r][j] = fv[j];
        }
        for (ANNOTATION t : annotations) {
            double[] dArray = W.getArray()[r];
            int n = this.terms.indexOf(t);
            dArray[n] = dArray[n] + 1.0;
        }
    }

    @Override
    public List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT image) {
        double[] fv = ((FeatureVector)this.extractor.extractFeature(image)).asDoubleVector();
        Matrix F = new Matrix((double[][])new double[][]{fv});
        Matrix res = F.times(this.transform);
        ArrayList<ScoredAnnotation<ANNOTATION>> ann = new ArrayList<ScoredAnnotation<ANNOTATION>>();
        for (int i = 0; i < this.terms.size(); ++i) {
            ann.add(new ScoredAnnotation<ANNOTATION>(this.terms.get(i), (float)res.get(0, i)));
        }
        Collections.sort(ann, new Comparator<ScoredAnnotation<ANNOTATION>>(){

            @Override
            public int compare(ScoredAnnotation<ANNOTATION> o1, ScoredAnnotation<ANNOTATION> o2) {
                return o1.confidence < o2.confidence ? 1 : -1;
            }
        });
        return ann;
    }

    @Override
    public Set<ANNOTATION> getAnnotations() {
        return new HashSet<ANNOTATION>(this.terms);
    }
}

