/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.osgi;

import org.ontoware.rdf2go.ModelFactory;
import org.ontoware.rdf2go.RDF2Go;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDF2GoActivator
implements BundleActivator,
ServiceListener {
    public static final String DEFAULTMODELFACTORY_CFG = "org.ontoware.rdf2go.defaultmodelfactory";
    public static final String MODEL_FACTORY_FILTER = "(objectclass=" + ModelFactory.class.getName() + ")";
    private BundleContext bc;
    private String defaultFactoryClassName = null;
    private ServiceReference currentFactorySR;
    private static final Logger log = LoggerFactory.getLogger(RDF2GoActivator.class);

    public void start(BundleContext context) throws Exception {
        this.bc = context;
        this.defaultFactoryClassName = context.getProperty(DEFAULTMODELFACTORY_CFG);
        this.bc.addServiceListener((ServiceListener)this, MODEL_FACTORY_FILTER);
        this.initalizeListener();
    }

    private void initalizeListener() {
        try {
            ServiceReference[] references = this.bc.getServiceReferences(null, MODEL_FACTORY_FILTER);
            for (int i = 0; references != null && i < references.length; ++i) {
                this.serviceChanged(new ServiceEvent(1, references[i]));
            }
        }
        catch (InvalidSyntaxException e) {
            log.error("Syntax error", (Throwable)e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.bc = null;
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.handleRegisteredEvent(event);
                break;
            }
            case 4: {
                this.handleUnregisteredEvent(event);
            }
        }
    }

    private void handleRegisteredEvent(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        ModelFactory factory = (ModelFactory)this.bc.getService(ref);
        String currClass = this.getCurrentFactoryClassName();
        String newClass = factory.getClass().getName();
        if (this.currentFactorySR == null) {
            log.debug("Registering " + factory.getClass().getName() + " as default ModelFactory");
            this.currentFactorySR = ref;
            RDF2Go.register(factory);
        } else if (this.defaultFactoryClassName != null && !currClass.equals(this.defaultFactoryClassName) && newClass.equals(this.defaultFactoryClassName)) {
            RDF2Go.register((ModelFactory)null);
            this.bc.ungetService(this.currentFactorySR);
            factory = (ModelFactory)this.bc.getService(ref);
            this.currentFactorySR = ref;
            RDF2Go.register(factory);
            log.debug("RDF2Go uses " + newClass + " as default ModelFactory");
        } else {
            this.bc.ungetService(ref);
        }
    }

    private void handleUnregisteredEvent(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        String currClass = this.getCurrentFactoryClassName();
        if (ref == this.currentFactorySR) {
            RDF2Go.register((ModelFactory)null);
            this.currentFactorySR = null;
            log.debug("RDF2Go unregistered the ModelFactory " + currClass + " as default ModelFactory. No ModelFactory available now. " + "The Bundle of the ModelFactory was unregistered.");
        }
        this.bc.ungetService(ref);
        this.initalizeListener();
    }

    private String getCurrentFactoryClassName() {
        ModelFactory currFactory = null;
        try {
            currFactory = RDF2Go.getModelFactory();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return currFactory == null ? null : currFactory.getClass().getName();
    }
}

