/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLArray;
import com.jmatio.types.MLEmptyArray;
import java.util.ArrayList;

public class MLCell
extends MLArray {
    private ArrayList<MLArray> cells = new ArrayList(this.getM() * this.getN());

    public MLCell(String name, int[] dims) {
        this(name, dims, 1, 0);
    }

    public MLCell(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
        int i = 0;
        while (i < this.getM() * this.getN()) {
            this.cells.add(new MLEmptyArray());
            ++i;
        }
    }

    public void set(MLArray value, int m, int n) {
        this.cells.set(this.getIndex(m, n), value);
    }

    public void set(MLArray value, int index) {
        this.cells.set(index, value);
    }

    public MLArray get(int m, int n) {
        return this.cells.get(this.getIndex(m, n));
    }

    public MLArray get(int index) {
        return this.cells.get(index);
    }

    @Override
    public int getIndex(int m, int n) {
        return m + n * this.getM();
    }

    public ArrayList<MLArray> cells() {
        return this.cells;
    }

    @Override
    public String contentToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + " = \n");
        int m = 0;
        while (m < this.getM()) {
            sb.append("\t");
            int n = 0;
            while (n < this.getN()) {
                sb.append(this.get(m, n));
                sb.append("\t");
                ++n;
            }
            sb.append("\n");
            ++m;
        }
        return sb.toString();
    }
}

