/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.pgm.vb.lda.mle;

import cern.jet.random.engine.MersenneTwister;
import org.openimaj.pgm.util.Corpus;
import org.openimaj.pgm.vb.lda.mle.LDAModel;

public interface LDABetaInitStrategy {
    public void initModel(LDAModel var1, Corpus var2);

    public static class RandomBetaInit
    implements LDABetaInitStrategy {
        private MersenneTwister random;

        public RandomBetaInit() {
            this.random = new MersenneTwister();
        }

        public RandomBetaInit(int seed) {
            this.random = new MersenneTwister(seed);
        }

        @Override
        public void initModel(LDAModel model, Corpus corpus) {
            for (int topicIndex = 0; topicIndex < model.ntopics; ++topicIndex) {
                for (int wordIndex = 0; wordIndex < corpus.vocabularySize(); ++wordIndex) {
                    double topicWord = 1.0 + this.random.nextDouble();
                    model.incTopicWord(topicIndex, wordIndex, topicWord);
                    model.incTopicTotal(topicIndex, topicWord);
                }
            }
        }
    }
}

