/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openimaj.ml.timeseries.IncompatibleTimeSeriesException;
import org.openimaj.ml.timeseries.TimeSeries;
import org.openimaj.ml.timeseries.TimeSeriesSetException;
import org.openimaj.ml.timeseries.converter.TimeSeriesConverter;
import org.openimaj.ml.timeseries.processor.TimeSeriesProcessor;
import org.openimaj.util.pair.IndependentPair;

public abstract class TimeSeriesCollection<ALLINPUT, SINGLEINPUT, TIMESERIES extends TimeSeriesCollection<ALLINPUT, SINGLEINPUT, TIMESERIES, INTERNALSERIES>, INTERNALSERIES extends TimeSeries<ALLINPUT, SINGLEINPUT, INTERNALSERIES>>
extends TimeSeries<Map<String, ALLINPUT>, Map<String, SINGLEINPUT>, TIMESERIES> {
    protected HashMap<String, INTERNALSERIES> timeSeriesHolder = new HashMap();

    public void addTimeSeries(String name, INTERNALSERIES series) throws IncompatibleTimeSeriesException {
        this.timeSeriesHolder.put(name, series);
    }

    public INTERNALSERIES series(String name) {
        return (INTERNALSERIES)((TimeSeries)this.timeSeriesHolder.get(name));
    }

    public Collection<INTERNALSERIES> allseries() {
        return this.timeSeriesHolder.values();
    }

    @Override
    public TIMESERIES get(long time, int nbefore, int nafter) {
        TimeSeriesCollection t = (TimeSeriesCollection)this.newInstance();
        HashMap inputs = new HashMap();
        long[] times = null;
        for (Map.Entry<String, INTERNALSERIES> a : this.timeSeriesHolder.entrySet()) {
            Object sub = ((TimeSeries)a.getValue()).get(time, nbefore, nafter);
            times = ((TimeSeries)sub).getTimes();
            inputs.put(a.getKey(), ((TimeSeries)sub).getData());
        }
        try {
            t.set(times, inputs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (TIMESERIES)t;
    }

    @Override
    public Map<String, ALLINPUT> getData() {
        HashMap ret = new HashMap();
        for (Map.Entry<String, INTERNALSERIES> es : this.timeSeriesHolder.entrySet()) {
            ret.put(es.getKey(), ((TimeSeries)es.getValue()).getData());
        }
        return ret;
    }

    @Override
    public TIMESERIES get(long start, long end) {
        TimeSeriesCollection t = (TimeSeriesCollection)this.newInstance();
        HashMap inputs = new HashMap();
        long[] times = null;
        for (Map.Entry<String, INTERNALSERIES> a : this.timeSeriesHolder.entrySet()) {
            Object sub = ((TimeSeries)a.getValue()).get(start, end);
            times = ((TimeSeries)sub).getTimes();
            inputs.put(a.getKey(), ((TimeSeries)sub).getData());
        }
        try {
            t.set(times, inputs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (TIMESERIES)t;
    }

    @Override
    public TIMESERIES get(long time, int nbefore, int nafter, TIMESERIES output) {
        HashMap inputs = new HashMap();
        long[] times = null;
        for (Map.Entry<String, INTERNALSERIES> a : this.timeSeriesHolder.entrySet()) {
            TimeSeries sub = ((TimeSeries)a.getValue()).get(time, nbefore, nafter, (TimeSeries)((TimeSeriesCollection)output).timeSeriesHolder.get(a.getKey()));
            times = sub.getTimes();
            inputs.put(a.getKey(), sub.getData());
        }
        try {
            ((TimeSeriesCollection)output).set(times, inputs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    public abstract INTERNALSERIES internalNewInstance();

    @Override
    public TIMESERIES get(long time, long threshbefore, long threshafter) {
        TimeSeriesCollection t = (TimeSeriesCollection)this.newInstance();
        HashMap inputs = new HashMap();
        long[] times = null;
        for (Map.Entry<String, INTERNALSERIES> a : this.timeSeriesHolder.entrySet()) {
            Object sub = ((TimeSeries)a.getValue()).get(time, threshbefore, threshafter);
            times = ((TimeSeries)sub).getTimes();
            inputs.put(a.getKey(), ((TimeSeries)sub).getData());
        }
        try {
            t.set(times, inputs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (TIMESERIES)t;
    }

    public TIMESERIES collectionByNames(String ... names) {
        HashMap ret = new HashMap();
        ArrayList<long[]> times = new ArrayList<long[]>();
        for (String name : names) {
            TimeSeries exists = (TimeSeries)this.timeSeriesHolder.get(name);
            if (exists == null) continue;
            ret.put(name, exists.getData());
            times.add(exists.getTimes());
        }
        TimeSeriesCollection rets = (TimeSeriesCollection)this.newInstance();
        Iterator titer = times.iterator();
        try {
            rets.set((long[])titer.next(), ret);
        }
        catch (TimeSeriesSetException timeSeriesSetException) {
            // empty catch block
        }
        return (TIMESERIES)rets;
    }

    public TIMESERIES collectionByNames(Collection<String> names) {
        return this.collectionByNames(names.toArray(new String[names.size()]));
    }

    public Set<String> getNames() {
        HashSet<String> copy = new HashSet<String>();
        for (String string : this.timeSeriesHolder.keySet()) {
            copy.add(string);
        }
        return copy;
    }

    public int nSeries() {
        return this.timeSeriesHolder.size();
    }

    public TIMESERIES processInternal(TimeSeriesProcessor<ALLINPUT, SINGLEINPUT, INTERNALSERIES> tsp) {
        TimeSeriesCollection inst = (TimeSeriesCollection)this.newInstance();
        for (Map.Entry<String, INTERNALSERIES> type : this.timeSeriesHolder.entrySet()) {
            try {
                inst.addTimeSeries(type.getKey(), ((TimeSeries)type.getValue()).process(tsp));
            }
            catch (IncompatibleTimeSeriesException incompatibleTimeSeriesException) {}
        }
        return (TIMESERIES)inst;
    }

    public TIMESERIES processInternalInplace(TimeSeriesProcessor<ALLINPUT, SINGLEINPUT, INTERNALSERIES> tsp) {
        TimeSeriesCollection inst = (TimeSeriesCollection)this.newInstance();
        for (Map.Entry<String, INTERNALSERIES> type : this.timeSeriesHolder.entrySet()) {
            try {
                inst.addTimeSeries(type.getKey(), ((TimeSeries)type.getValue()).processInplace(tsp));
            }
            catch (IncompatibleTimeSeriesException incompatibleTimeSeriesException) {}
        }
        return (TIMESERIES)inst;
    }

    public <OUTPUTALL, OUTPUTSINGLE, OUTPUTTS extends TimeSeries<OUTPUTALL, OUTPUTSINGLE, OUTPUTTS>, OUTPUTTSC extends TimeSeriesCollection<OUTPUTALL, OUTPUTSINGLE, OUTPUTTSC, OUTPUTTS>> OUTPUTTSC convertInternal(TimeSeriesConverter<ALLINPUT, SINGLEINPUT, INTERNALSERIES, OUTPUTALL, OUTPUTSINGLE, OUTPUTTS> tsc, OUTPUTTSC inst) {
        for (Map.Entry<String, INTERNALSERIES> type : this.timeSeriesHolder.entrySet()) {
            try {
                inst.addTimeSeries(type.getKey(), ((TimeSeries)type.getValue()).convert(tsc));
            }
            catch (IncompatibleTimeSeriesException incompatibleTimeSeriesException) {}
        }
        return inst;
    }

    public <OUTPUTALL, OUTPUTSINGLE, OUTPUTTS extends TimeSeries<OUTPUTALL, OUTPUTSINGLE, OUTPUTTS>, OUTPUTTSC extends TimeSeriesCollection<OUTPUTALL, OUTPUTSINGLE, OUTPUTTSC, OUTPUTTS>> OUTPUTTSC convertInternal(TimeSeriesConverter<ALLINPUT, SINGLEINPUT, INTERNALSERIES, OUTPUTALL, OUTPUTSINGLE, OUTPUTTS> tsc, TimeSeriesProcessor<OUTPUTALL, OUTPUTSINGLE, OUTPUTTS> tsp, OUTPUTTSC inst) {
        for (Map.Entry<String, INTERNALSERIES> type : this.timeSeriesHolder.entrySet()) {
            try {
                inst.addTimeSeries(type.getKey(), ((TimeSeries)type.getValue()).convert(tsc, tsp));
            }
            catch (IncompatibleTimeSeriesException incompatibleTimeSeriesException) {}
        }
        return inst;
    }

    @Override
    public Iterator<IndependentPair<Long, Map<String, SINGLEINPUT>>> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] getTimes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long[] time, Map<String, ALLINPUT> data) throws TimeSeriesSetException {
        for (Map.Entry<String, ALLINPUT> l : data.entrySet()) {
            INTERNALSERIES instance = this.internalNewInstance();
            ((TimeSeries)instance).internalAssign(time, l.getValue());
            this.timeSeriesHolder.put(l.getKey(), instance);
        }
    }
}

