/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.matlib.loss;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.SparseMatrix;
import org.openimaj.math.matrix.MatlibMatrixUtils;
import org.openimaj.ml.linear.learner.matlib.loss.LossFunction;

public class MatLossFunction
extends LossFunction {
    private LossFunction f;

    public MatLossFunction(LossFunction f) {
        this.f = f;
    }

    @Override
    public void setX(Matrix X) {
        super.setX(X);
        this.f.setX(X);
    }

    @Override
    public void setY(Matrix Y) {
        super.setY(Y);
        this.f.setY(Y);
    }

    @Override
    public void setBias(Matrix bias) {
        super.setBias(bias);
        this.f.setBias(bias);
    }

    @Override
    public Matrix gradient(Matrix W) {
        SparseMatrix ret = SparseMatrix.sparse((int)W.rowCount(), (int)W.columnCount());
        int allRowsY = this.Y.rowCount() - 1;
        int allRowsW = W.rowCount() - 1;
        for (int i = 0; i < this.Y.columnCount(); ++i) {
            this.f.setY(MatlibMatrixUtils.subMatrix((Matrix)this.Y, (int)0, (int)allRowsY, (int)i, (int)i));
            if (this.bias != null) {
                this.f.setBias(MatlibMatrixUtils.subMatrix((Matrix)this.bias, (int)0, (int)allRowsY, (int)i, (int)i));
            }
            Matrix w = MatlibMatrixUtils.subMatrix((Matrix)W, (int)0, (int)allRowsW, (int)i, (int)i);
            Matrix submatrix = this.f.gradient(w);
            MatlibMatrixUtils.setSubMatrix((Matrix)ret, (int)0, (int)i, (Matrix)submatrix);
        }
        return ret;
    }

    @Override
    public double eval(Matrix W) {
        double total = 0.0;
        this.f.setBias(this.bias);
        return total += this.f.eval(W);
    }

    @Override
    public boolean isMatrixLoss() {
        return true;
    }
}

