/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.loss;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Matrix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openimaj.ml.linear.learner.loss.LossFunction;

public class SquareMissingLossFunction
extends LossFunction {
    Logger logger = LogManager.getLogger(SquareMissingLossFunction.class);

    @Override
    public Matrix gradient(Matrix W) {
        Matrix resid = (Matrix)this.X.times(W).minus((Ring)this.Y);
        if (this.bias != null) {
            resid.plusEquals((Ring)this.bias);
        }
        for (int r = 0; r < this.Y.getNumRows(); ++r) {
            double yc = this.Y.getElement(r, 0);
            if (!Double.isNaN(yc)) continue;
            resid.setElement(r, 0, 0.0);
        }
        return this.X.transpose().times(resid);
    }

    @Override
    public double eval(Matrix W) {
        Matrix v = W == null ? this.X : this.X.times(W);
        Matrix vWithoutBias = v.clone();
        if (this.bias != null) {
            v.plusEquals((Ring)this.bias);
        }
        double sum = 0.0;
        for (int r = 0; r < this.Y.getNumRows(); ++r) {
            for (int c = 0; c < this.Y.getNumColumns(); ++c) {
                double yr = this.Y.getElement(r, c);
                if (Double.isNaN(yr)) continue;
                double val = v.getElement(r, c);
                double valNoBias = vWithoutBias.getElement(r, c);
                double delta = yr - val;
                this.logger.debug(String.format("yr=%d,y=%3.2f,v=%3.2f,v(no bias)=%2.5f,delta=%2.5f", r, yr, val, valNoBias, delta));
                sum += delta * delta;
            }
        }
        return sum;
    }

    @Override
    public boolean isMatrixLoss() {
        return false;
    }
}

