/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.experiments.sinabill;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openimaj.ml.linear.learner.BilinearLearnerParameters;
import org.openimaj.util.pair.IndependentPair;

public class BilinearLearnerParametersLineSearch
implements Iterable<BilinearLearnerParameters> {
    private Map<String, Iterable<?>> itermap = new HashMap();
    private BilinearLearnerParameters base;

    public BilinearLearnerParametersLineSearch(BilinearLearnerParameters base) {
        this.base = base;
    }

    public <T> void addIteration(String key, Iterable<T> range) {
        this.itermap.put(key, range);
    }

    @Override
    public Iterator<BilinearLearnerParameters> iterator() {
        final ArrayList<IndependentPair> iterators = new ArrayList<IndependentPair>();
        for (Map.Entry<String, Iterable<?>> iterent : this.itermap.entrySet()) {
            Iterator<?> iterator = iterent.getValue().iterator();
            IndependentPair pair = new IndependentPair((Object)iterent.getKey(), iterator);
            iterators.add(pair);
        }
        final ArrayList current = new ArrayList();
        return new Iterator<BilinearLearnerParameters>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public BilinearLearnerParameters next() {
                if (current.size() == 0) {
                    for (IndependentPair iterip : iterators) {
                        Object next = ((Iterator)iterip.secondObject()).next();
                        current.add(IndependentPair.pair((Object)iterip.firstObject(), next));
                    }
                } else {
                    for (int i = 0; i < iterators.size(); ++i) {
                        IndependentPair namedIterator = (IndependentPair)iterators.get(i);
                        String name = (String)namedIterator.firstObject();
                        if (((Iterator)namedIterator.secondObject()).hasNext()) {
                            Object next = ((Iterator)namedIterator.secondObject()).next();
                            current.set(i, IndependentPair.pair((Object)name, next));
                            break;
                        }
                        Iterator valueIter = ((Iterable)BilinearLearnerParametersLineSearch.this.itermap.get(name)).iterator();
                        IndependentPair pair = new IndependentPair((Object)name, valueIter);
                        iterators.set(i, pair);
                        Object next = valueIter.next();
                        current.set(i, IndependentPair.pair((Object)name, next));
                    }
                }
                BilinearLearnerParameters params = BilinearLearnerParametersLineSearch.this.base.clone();
                for (IndependentPair namedObject : current) {
                    params.put(namedObject.firstObject(), namedObject.secondObject());
                }
                return params;
            }

            @Override
            public boolean hasNext() {
                for (IndependentPair independentPair : iterators) {
                    if (!((Iterator)independentPair.secondObject()).hasNext()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static void main(String[] args) {
        BilinearLearnerParametersLineSearch ls = new BilinearLearnerParametersLineSearch(new BilinearLearnerParameters());
        ls.addIteration("eta0u", Doubles.asList((double[])new double[]{0.1, 0.01}));
        ls.addIteration("eta0w", Doubles.asList((double[])new double[]{51.0, 52.0, 53.0}));
        for (BilinearLearnerParameters bilinearLearnerParameters : ls) {
            System.out.println(bilinearLearnerParameters);
        }
    }
}

