/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.experiments.sinabill;

import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openimaj.ml.linear.learner.BilinearLearnerParameters;

public abstract class BilinearExperiment {
    private static final String EXPERIMENT_NAME = "%s/%s/%s_%s";
    private static final String PARAMS_NAME = ".paramsascii";
    private static final String PARAMS_DATA_NAME = ".params";
    private static final String BILL_DATA_ROOT = "%s/TrendMiner/deliverables/year2-18month/Austrian Data/";
    private static final String BILL_DATA = "%s/data.mat";
    Logger logger = LogManager.getLogger(this.getClass());
    private static long experimentTime = -1L;

    protected void prepareExperimentLog(BilinearLearnerParameters params) throws IOException {
    }

    public File prepareExperimentRoot() throws IOException {
        String experimentRoot = String.format(EXPERIMENT_NAME, this.DATA_ROOT(), this.getExperimentSetName(), this.getExperimentName(), "" + this.currentExperimentTime());
        File expRoot = new File(experimentRoot);
        if (expRoot.exists() && expRoot.isDirectory()) {
            return expRoot;
        }
        this.logger.debug("Experiment root: " + expRoot);
        if (!expRoot.mkdirs()) {
            throw new IOException("Couldn't prepare experiment output");
        }
        return expRoot;
    }

    private long currentExperimentTime() {
        if (experimentTime == -1L) {
            experimentTime = System.currentTimeMillis();
        }
        return experimentTime;
    }

    protected String FOLD_ROOT(int fold) throws IOException {
        File foldRoot = new File(this.prepareExperimentRoot(), String.format("fold_%d", fold));
        if (!foldRoot.exists() && !foldRoot.mkdirs()) {
            throw new IOException("Failed creating the fold directory: " + foldRoot);
        }
        return foldRoot.getAbsolutePath();
    }

    protected String MATLAB_DATA() {
        return String.format(BILL_DATA, this.DATA_ROOT());
    }

    protected String MATLAB_DATA(String data) {
        return String.format(data, this.DATA_ROOT());
    }

    protected String DATA_ROOT() {
        return String.format(BILL_DATA_ROOT, this.DROPBOX_HOME());
    }

    private String DROPBOX_HOME() {
        String home = System.getProperty("user.home");
        return String.format("%s/Dropbox", home);
    }

    public abstract void performExperiment() throws Exception;

    public String getExperimentName() {
        return "experiment";
    }

    public String getExperimentSetName() {
        return "streamingExperiments";
    }
}

