/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.experiments.sinabill;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.mtj.DenseVectorFactoryMTJ;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.openimaj.io.IOUtils;
import org.openimaj.io.WriteableBinary;
import org.openimaj.ml.linear.data.BillMatlabFileDataGenerator;
import org.openimaj.ml.linear.experiments.sinabill.ArrayIndexComparator;
import org.openimaj.ml.linear.experiments.sinabill.BilinearExperiment;
import org.openimaj.ml.linear.learner.BilinearLearnerParameters;
import org.openimaj.ml.linear.learner.BilinearSparseOnlineLearner;
import org.openimaj.ml.linear.learner.init.SingleValueInitStrat;
import org.openimaj.ml.linear.learner.init.SparseZerosInitStrategy;
import org.openimaj.util.pair.Pair;

public class AustrianWordExperiments
extends BilinearExperiment {
    public static void main(String[] args) throws IOException {
        AustrianWordExperiments exp = new AustrianWordExperiments();
        exp.performExperiment();
    }

    @Override
    public void performExperiment() throws IOException {
        BilinearLearnerParameters params = new BilinearLearnerParameters();
        params.put("eta0u", 2.0E-4);
        params.put("eta0w", 0.002);
        params.put("lambda", 0.001);
        params.put("biconvex_tol", 0.05);
        params.put("biconvex_maxiter", 5);
        params.put("bias", true);
        params.put("biaseta0", 0.05);
        params.put("winitstrat", new SingleValueInitStrat(0.1));
        params.put("uinitstrat", new SparseZerosInitStrategy());
        BillMatlabFileDataGenerator bmfdg = new BillMatlabFileDataGenerator(new File(this.MATLAB_DATA()), 98, true);
        this.prepareExperimentLog(params);
        boolean fold = false;
        File foldParamFile = new File("/Users/ss/Dropbox/TrendMiner/deliverables/year2-18month/Austrian Data/streamingExperiments/experiment_1365684128359/fold_0_learner");
        this.logger.debug("Fold: 0");
        BilinearSparseOnlineLearner learner = new BilinearSparseOnlineLearner(params);
        learner.reinitParams();
        bmfdg.setFold(0, BillMatlabFileDataGenerator.Mode.TEST);
        this.logger.debug("...training");
        bmfdg.setFold(0, BillMatlabFileDataGenerator.Mode.TRAINING);
        int j = 0;
        if (!foldParamFile.exists()) {
            Pair<Matrix> next;
            while ((next = bmfdg.generate()) != null) {
                this.logger.debug("...trying item " + j++);
                learner.process((Matrix)next.firstObject(), (Matrix)next.secondObject());
            }
            System.out.println("Writing W and U to: " + foldParamFile);
            IOUtils.writeBinary((File)foldParamFile, (WriteableBinary)learner);
        } else {
            learner = (BilinearSparseOnlineLearner)IOUtils.read((File)foldParamFile, BilinearSparseOnlineLearner.class);
        }
        Matrix w = learner.getW();
        int ncols = w.getNumColumns();
        int nwords = 20;
        for (int c = 0; c < ncols; ++c) {
            System.out.println("Top 20 words for: " + bmfdg.getTasks()[c]);
            Vector col = w.getColumn(c);
            double[] wordWeights = new DenseVectorFactoryMTJ().copyVector(col).getArray();
            Integer[] integerRange = ArrayIndexComparator.integerRange(wordWeights);
            Arrays.sort(integerRange, new ArrayIndexComparator(wordWeights));
            for (int i = wordWeights.length - 1; i >= wordWeights.length - 20; --i) {
                System.out.printf("%s: %1.5f\n", bmfdg.getVocabulary().get(integerRange[i]), wordWeights[integerRange[i]]);
            }
        }
    }
}

