/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation.basic.util;

import cern.jet.random.EmpiricalWalker;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Collection;
import java.util.List;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.basic.util.NumAnnotationsChooser;

public class PriorChooser
implements NumAnnotationsChooser {
    private EmpiricalWalker numAnnotations;

    @Override
    public <O, A> void train(List<? extends Annotated<O, A>> data) {
        TIntIntHashMap nAnnotationCounts = new TIntIntHashMap();
        int maxVal = 0;
        for (Annotated<O, A> sample : data) {
            Collection<A> annos = sample.getAnnotations();
            nAnnotationCounts.adjustOrPutValue(annos.size(), 1, 1);
            if (annos.size() <= maxVal) continue;
            maxVal = annos.size();
        }
        double[] distr = new double[maxVal + 1];
        for (int i = 0; i <= maxVal; ++i) {
            distr[i] = nAnnotationCounts.get(i);
        }
        this.numAnnotations = new EmpiricalWalker(distr, 1, (RandomEngine)new MersenneTwister());
    }

    @Override
    public int numAnnotations() {
        return this.numAnnotations.nextInt();
    }
}

