/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.ml.annotation.Annotated;

public class AnnotatedObject<OBJECT, ANNOTATION>
implements Annotated<OBJECT, ANNOTATION> {
    public OBJECT object;
    public Collection<ANNOTATION> annotations;

    public AnnotatedObject(OBJECT object, Collection<ANNOTATION> annotations) {
        this.object = object;
        this.annotations = annotations;
    }

    public AnnotatedObject(OBJECT object, ANNOTATION annotation) {
        this.object = object;
        this.annotations = new ArrayList<ANNOTATION>();
        this.annotations.add(annotation);
    }

    @Override
    public OBJECT getObject() {
        return this.object;
    }

    @Override
    public Collection<ANNOTATION> getAnnotations() {
        return this.annotations;
    }

    public static <OBJECT, ANNOTATION> AnnotatedObject<OBJECT, ANNOTATION> create(OBJECT object, Collection<ANNOTATION> annotations) {
        return new AnnotatedObject<OBJECT, Collection<ANNOTATION>>(object, annotations);
    }

    public static <OBJECT, ANNOTATION> AnnotatedObject<OBJECT, ANNOTATION> create(OBJECT object, ANNOTATION annotation) {
        return new AnnotatedObject<OBJECT, ANNOTATION>(object, annotation);
    }

    public static <OBJECT, ANNOTATION> List<AnnotatedObject<OBJECT, ANNOTATION>> createList(GroupedDataset<ANNOTATION, ? extends ListDataset<OBJECT>, OBJECT> dataset) {
        HashMap annotated = new HashMap(dataset.numInstances());
        for (Object grp : dataset.getGroups()) {
            for (Object inst : (ListDataset)dataset.getInstances(grp)) {
                AnnotatedObject ao = (AnnotatedObject)annotated.get(inst);
                if (ao == null) {
                    annotated.put(inst, new AnnotatedObject(inst, grp));
                    continue;
                }
                ao.annotations.add(grp);
            }
        }
        return new ArrayList<AnnotatedObject<OBJECT, ANNOTATION>>(annotated.values());
    }

    public static <OBJECT, ANNOTATION> List<AnnotatedObject<OBJECT, ANNOTATION>> createList(OBJECT[] objs, ANNOTATION[] anns) {
        ArrayList<AnnotatedObject<OBJECT, ANNOTATION>> list = new ArrayList<AnnotatedObject<OBJECT, ANNOTATION>>();
        for (int i = 0; i < objs.length; ++i) {
            list.add(AnnotatedObject.create(objs[i], anns[i]));
        }
        return list;
    }

    public static <OBJECT, ANNOTATION> List<AnnotatedObject<OBJECT, ANNOTATION>> createList(OBJECT[] objs, ANNOTATION[][] anns) {
        ArrayList<AnnotatedObject<OBJECT, ANNOTATION>> list = new ArrayList<AnnotatedObject<OBJECT, ANNOTATION>>();
        for (int i = 0; i < objs.length; ++i) {
            for (ANNOTATION a : anns[i]) {
                list.add(AnnotatedObject.create(objs[i], a));
            }
        }
        return list;
    }
}

