/*
 * Decompiled with CFR 0.152.
 */
package org.multihelp.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import org.multihelp.HelpViewer;
import org.multihelp.file.FileNode;

public class SourceFile
extends FileNode {
    private static final long serialVersionUID = 2L;
    File base;
    boolean isDirectory;
    private Icon icon = null;
    private String text = "";
    Filter filter = new Filter();

    public SourceFile(File root) {
        super(root);
        this.base = root;
        this.isDirectory = this.base.isDirectory();
        if (root.getName().endsWith(".java")) {
            this.icon = new ImageIcon("icons/java.jpg");
            this.text = root.getName().substring(0, root.getName().lastIndexOf(".java"));
        } else if (root.getName().endsWith(".xml")) {
            this.icon = new ImageIcon("xml.png");
            this.text = root.getName().substring(0, root.getName().lastIndexOf(".xml"));
        } else {
            this.text = root.getName();
        }
    }

    @Override
    public void setPage(HelpViewer viewer) {
        if (this.isDirectory) {
            String header = "<html><body><ul>";
            String footer = "</ul></body></html>";
            StringBuffer content = new StringBuffer();
            File[] children = this.base.listFiles();
            if (children != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    content.append("<li>" + children[i].getName() + "</li>");
                    ++i;
                }
            }
            HTMLDocument doc = new HTMLDocument();
            try {
                doc.insertString(0, String.valueOf(header) + content.toString() + footer, null);
                try {
                    doc.setBase(this.base.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            catch (BadLocationException e) {
                Logger.getLogger(this.getClass().getCanonicalName());
            }
            viewer.setContentType("text/html");
            viewer.setDocument(doc);
        } else {
            try {
                FileReader stream = new FileReader(this.base);
                char[] buffer = new char[10240];
                StringBuffer fileBuffer = new StringBuffer();
                int read = 0;
                while ((read = stream.read(buffer)) > 0) {
                    fileBuffer.append(buffer, 0, read);
                }
                String file = fileBuffer.toString();
                Pattern lt = Pattern.compile("<");
                Matcher match = lt.matcher(file);
                file = match.replaceAll("&lt;");
                Pattern gt = Pattern.compile(">");
                match = gt.matcher(file);
                file = match.replaceAll("&gt;");
                Pattern amp = Pattern.compile("&");
                match = amp.matcher(file);
                file = match.replaceAll("&amp;");
                HTMLDocument doc = new HTMLDocument();
                try {
                    doc.insertString(0, "<html><body><code><pre>" + file + "</pre></code></body></html>", null);
                    doc.setBase(this.base.toURI().toURL());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                viewer.setContentType("text/html");
                viewer.setDocument(doc);
            }
            catch (FileNotFoundException e) {
                HTMLDocument doc = new HTMLDocument();
                try {
                    doc.insertString(0, "<html><body>ERROR: Help file '" + this.base.getAbsolutePath() + "' not found</body></html>", null);
                    try {
                        doc.setBase(this.base.toURI().toURL());
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                viewer.setContentType("text/html");
                viewer.setDocument(doc);
                e.printStackTrace();
            }
            catch (IOException e) {
                HTMLDocument doc = new HTMLDocument();
                try {
                    doc.insertString(0, "<html><body>ERROR: Help file '" + this.base.getAbsolutePath() + "' had an IO error</body></html>", null);
                    try {
                        doc.setBase(this.base.toURI().toURL());
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                viewer.setContentType("text/html");
                viewer.setDocument(doc);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void traverseFileSystem(File root, int depth) {
        File[] children;
        if (depth < 512 && (children = root.listFiles()) != null && children.length != 0) {
            int i = 0;
            while (i < children.length) {
                if (this.filter.accept(children[i])) {
                    SourceFile childNode = new SourceFile(children[i]);
                    this.add(childNode);
                    childNode.setParent(this);
                    childNode.traverseFileSystem(children[i], depth + 1);
                }
                ++i;
            }
        }
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public class Filter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            if (pathname.getName().endsWith(".java")) {
                return true;
            }
            return pathname.getName().endsWith(".xml");
        }
    }
}

