/*
 * Decompiled with CFR 0.152.
 */
package org.multihelp.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import org.multihelp.HelpViewer;
import org.multihelp.file.FileNode;

public class DefaultFile
extends FileNode {
    File base;

    public DefaultFile(File root) {
        super(root);
        this.base = root;
    }

    @Override
    public void setPage(HelpViewer viewer) {
        block15: {
            try {
                File source = this.base;
                if (source.isDirectory()) {
                    source = new File(String.valueOf(this.base.getCanonicalPath()) + File.pathSeparator + "index.html");
                }
                if (!source.exists()) break block15;
                FileReader stream = new FileReader(this.base);
                char[] buffer = new char[10240];
                StringBuffer fileBuffer = new StringBuffer();
                int read = 0;
                while ((read = stream.read(buffer)) > 0) {
                    fileBuffer.append(buffer, 0, read);
                }
                String file = fileBuffer.toString();
                Pattern lt = Pattern.compile("<");
                Matcher match = lt.matcher(file);
                file = match.replaceAll("&lt;");
                Pattern gt = Pattern.compile(">");
                match = gt.matcher(file);
                file = match.replaceAll("&gt;");
                Pattern amp = Pattern.compile("&");
                match = amp.matcher(file);
                file = match.replaceAll("&amp;");
                HTMLDocument doc = new HTMLDocument();
                try {
                    doc.insertString(0, "<html><body><pre>" + file + "</pre></body></html>", null);
                    doc.setBase(this.base.toURI().toURL());
                }
                catch (BadLocationException e) {
                    Logger.getLogger(this.getClass().getCanonicalName());
                }
                viewer.setContentType("text/html");
                viewer.setDocument(doc);
            }
            catch (FileNotFoundException e) {
                HTMLDocument doc = new HTMLDocument();
                try {
                    doc.insertString(0, "<html><body>ERROR: Help file '" + this.base.getAbsolutePath() + "' not found</body></html>", null);
                    try {
                        doc.setBase(this.base.toURI().toURL());
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (BadLocationException e1) {
                    Logger.getLogger(this.getClass().getCanonicalName());
                }
                viewer.setContentType("text/html");
                viewer.setDocument(doc);
                e.printStackTrace();
                Logger.getLogger(this.getClass().getCanonicalName());
            }
            catch (IOException e) {
                HTMLDocument doc = new HTMLDocument();
                try {
                    doc.insertString(0, "<html><body>ERROR: Help file '" + this.base.getAbsolutePath() + "' had an IO error</body></html>", null);
                    try {
                        doc.setBase(this.base.toURI().toURL());
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (BadLocationException e1) {
                    Logger.getLogger(this.getClass().getCanonicalName());
                }
                viewer.setContentType("text/html");
                viewer.setDocument(doc);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void traverseFileSystem(File root, int depth) {
        File[] children;
        if (depth < 512 && (children = root.listFiles()) != null && children.length != 0) {
            int i = 0;
            while (i < children.length) {
                FileNode childNode = FileNode.determineType(children[i]);
                this.add(childNode);
                childNode.setParent(this);
                childNode.traverseFileSystem(children[i], depth + 1);
                ++i;
            }
        }
    }

    @Override
    public String getText() {
        return this.base.getName();
    }
}

