/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.AggregatorContainer;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.Cancel;
import jAudioFeatureExtractor.ExplicitCancel;
import jAudioFeatureExtractor.GeneralTools.Statistics;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import jAudioFeatureExtractor.Updater;
import jAudioFeatureExtractor.jAudioTools.AudioSamples;
import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class FeatureProcessor {
    private int window_size;
    private int window_overlap_offset;
    private double sampling_rate;
    private boolean normalise;
    private FeatureExtractor[] feature_extractors;
    private int[][] feature_extractor_dependencies;
    private int[] max_feature_offsets;
    private boolean[] features_to_save;
    private boolean save_features_for_each_window;
    private boolean save_overall_recording_features;
    private DataOutputStream values_writer;
    private DataOutputStream definitions_writer;
    private boolean definitions_written;
    private int outputType;
    private boolean isARFFOverallHeaderWritten = false;
    private Updater updater;
    private Cancel cancel;
    private AggregatorContainer aggregator;

    public FeatureProcessor(int window_size, double window_overlap, double sampling_rate, boolean normalise, FeatureExtractor[] all_feature_extractors, boolean[] features_to_save_among_all, boolean save_features_for_each_window, boolean save_overall_recording_features, OutputStream feature_values_save_path, OutputStream feature_definitions_save_path, int outputType, Cancel cancel, AggregatorContainer container) throws Exception {
        this.cancel = cancel;
        if (container != null) {
            if (container.getNumberOfAggregators() == 0 && save_overall_recording_features) {
                throw new Exception("Saving aggregated values for each file without any aggregators specified");
            }
        } else if (save_overall_recording_features) {
            throw new Exception("Saving aggregators for each file but executed without setting a non-null AggregatorContainer object");
        }
        this.aggregator = container;
        if (!save_features_for_each_window && !save_overall_recording_features) {
            throw new Exception("You must save at least one of the windows-based\nfeatures and the overall file-based features.");
        }
        if (window_overlap < 0.0 || window_overlap >= 1.0) {
            throw new Exception("Window overlap fraction is " + window_overlap + ".\n" + "This value must be 0.0 or above and less than 1.0.");
        }
        if (window_size < 3) {
            throw new Exception("Window size is " + window_size + ".\n" + "This value must be above 2.");
        }
        boolean one_selected = false;
        int i = 0;
        while (i < features_to_save_among_all.length) {
            if (features_to_save_among_all[i]) {
                one_selected = true;
            }
            ++i;
        }
        if (!one_selected) {
            throw new Exception("No features have been set to be saved.");
        }
        if (outputType != 0 && outputType != 1) {
            throw new Exception("INTERNAL ERROR - only ARFF and ACE output files are supported");
        }
        this.outputType = outputType;
        this.values_writer = new DataOutputStream(feature_values_save_path);
        this.definitions_writer = new DataOutputStream(feature_definitions_save_path);
        this.definitions_written = false;
        this.window_size = window_size;
        this.sampling_rate = sampling_rate;
        this.normalise = normalise;
        this.save_features_for_each_window = save_features_for_each_window;
        this.save_overall_recording_features = save_overall_recording_features;
        this.window_overlap_offset = (int)(window_overlap * (double)window_size);
        this.findAndOrderFeaturesToExtract(all_feature_extractors, features_to_save_among_all);
        if (outputType == 0) {
            this.writeValuesXMLHeader();
        } else if (outputType == 1) {
            this.writeValuesARFFHeader();
        }
    }

    public void extractFeatures(File recording_file, Updater updater) throws Exception {
        this.updater = updater;
        double[] samples = this.preProcessRecording(recording_file);
        if (this.cancel.isCancel()) {
            throw new ExplicitCancel("Killed after loading data");
        }
        LinkedList<Integer> window_start_indices_list = new LinkedList<Integer>();
        int this_start = 0;
        while (this_start < samples.length) {
            window_start_indices_list.add(new Integer(this_start));
            this_start += this.window_size - this.window_overlap_offset;
        }
        Integer[] window_start_indices_I = window_start_indices_list.toArray(new Integer[1]);
        int[] window_start_indices = new int[window_start_indices_I.length];
        if (updater != null) {
            updater.setFileLength(window_start_indices.length);
        }
        int i = 0;
        while (i < window_start_indices.length) {
            window_start_indices[i] = window_start_indices_I[i];
            ++i;
        }
        double[][][] window_feature_values = this.getFeatures(samples, window_start_indices);
        if (this.save_overall_recording_features) {
            this.aggregator.add(this.feature_extractors, this.features_to_save);
            this.aggregator.aggregate(window_feature_values);
        }
        if (this.outputType == 0) {
            this.saveACEFeatureVectorsForARecording(window_feature_values, window_start_indices, recording_file.getPath(), this.aggregator);
        } else if (this.outputType == 1) {
            this.saveARFFFeatureVectorsForARecording(window_feature_values, window_start_indices, recording_file.getPath(), this.aggregator);
        }
        if (!this.definitions_written && this.outputType == 0) {
            this.saveFeatureDefinitions(window_feature_values, this.aggregator);
        }
    }

    public void finalize() throws Exception {
        if (this.outputType == 0) {
            this.values_writer.writeBytes("</feature_vector_file>");
        }
        this.values_writer.close();
    }

    private void findAndOrderFeaturesToExtract(FeatureExtractor[] all_feature_extractors, boolean[] features_to_save_among_all) {
        int j;
        int i;
        String[] all_feature_names = new String[all_feature_extractors.length];
        int feat = 0;
        while (feat < all_feature_extractors.length) {
            all_feature_names[feat] = all_feature_extractors[feat].getFeatureDefinition().name;
            ++feat;
        }
        String[][] dependencies = new String[all_feature_extractors.length][];
        int feat2 = 0;
        while (feat2 < all_feature_extractors.length) {
            dependencies[feat2] = features_to_save_among_all[feat2] ? all_feature_extractors[feat2].getDepenedencies() : null;
            ++feat2;
        }
        boolean done = false;
        boolean[] features_to_extract = new boolean[dependencies.length];
        int feat3 = 0;
        while (feat3 < features_to_extract.length) {
            features_to_extract[feat3] = features_to_save_among_all[feat3];
            ++feat3;
        }
        while (!done) {
            done = true;
            feat3 = 0;
            while (feat3 < dependencies.length) {
                if (dependencies[feat3] != null) {
                    i = 0;
                    while (i < dependencies[feat3].length) {
                        String name = dependencies[feat3][i];
                        int j2 = 0;
                        while (j2 < all_feature_names.length) {
                            if (name.equals(all_feature_names[j2])) {
                                if (!features_to_extract[j2]) {
                                    features_to_extract[j2] = true;
                                    dependencies[j2] = all_feature_extractors[j2].getDepenedencies();
                                    if (dependencies[j2] != null) {
                                        done = false;
                                    }
                                }
                                j2 = all_feature_names.length;
                            }
                            ++j2;
                        }
                        ++i;
                    }
                }
                ++feat3;
            }
        }
        int number_features_to_extract = 0;
        i = 0;
        while (i < features_to_extract.length) {
            if (features_to_extract[i]) {
                ++number_features_to_extract;
            }
            ++i;
        }
        this.feature_extractors = new FeatureExtractor[number_features_to_extract];
        this.features_to_save = new boolean[number_features_to_extract];
        i = 0;
        while (i < this.features_to_save.length) {
            this.features_to_save[i] = false;
            ++i;
        }
        boolean[] feature_added = new boolean[dependencies.length];
        int i2 = 0;
        while (i2 < feature_added.length) {
            feature_added[i2] = false;
            ++i2;
        }
        int current_position = 0;
        done = false;
        while (!done) {
            done = true;
            int feat4 = 0;
            while (feat4 < dependencies.length) {
                if (features_to_extract[feat4] && !feature_added[feat4] && dependencies[feat4] == null) {
                    feature_added[feat4] = true;
                    this.feature_extractors[current_position] = all_feature_extractors[feat4];
                    this.features_to_save[current_position] = features_to_save_among_all[feat4];
                    ++current_position;
                    done = false;
                    int i3 = 0;
                    while (i3 < dependencies.length) {
                        if (features_to_extract[i3] && dependencies[i3] != null) {
                            int num_defs = dependencies[i3].length;
                            j = 0;
                            while (j < num_defs) {
                                if (dependencies[i3][j].equals(all_feature_names[feat4])) {
                                    if (dependencies[i3].length == 1) {
                                        dependencies[i3] = null;
                                        j = num_defs;
                                    } else {
                                        String[] temp = new String[dependencies[i3].length - 1];
                                        int m = 0;
                                        int k = 0;
                                        while (k < dependencies[i3].length) {
                                            if (k != j) {
                                                temp[m] = dependencies[i3][k];
                                                ++m;
                                            }
                                            ++k;
                                        }
                                        dependencies[i3] = temp;
                                        --j;
                                        --num_defs;
                                    }
                                }
                                ++j;
                            }
                        }
                        ++i3;
                    }
                }
                ++feat4;
            }
        }
        this.feature_extractor_dependencies = new int[this.feature_extractors.length][];
        String[] feature_names = new String[this.feature_extractors.length];
        int feat5 = 0;
        while (feat5 < feature_names.length) {
            feature_names[feat5] = this.feature_extractors[feat5].getFeatureDefinition().name;
            ++feat5;
        }
        String[][] feature_dependencies_str = new String[this.feature_extractors.length][];
        int feat6 = 0;
        while (feat6 < feature_dependencies_str.length) {
            feature_dependencies_str[feat6] = this.feature_extractors[feat6].getDepenedencies();
            ++feat6;
        }
        int i4 = 0;
        while (i4 < feature_dependencies_str.length) {
            if (feature_dependencies_str[i4] != null) {
                this.feature_extractor_dependencies[i4] = new int[feature_dependencies_str[i4].length];
                j = 0;
                while (j < feature_dependencies_str[i4].length) {
                    int k = 0;
                    while (k < feature_names.length) {
                        if (feature_dependencies_str[i4][j].equals(feature_names[k])) {
                            this.feature_extractor_dependencies[i4][j] = k;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i4;
        }
        this.max_feature_offsets = new int[this.feature_extractors.length];
        i4 = 0;
        while (i4 < this.max_feature_offsets.length) {
            if (this.feature_extractors[i4].getDepenedencyOffsets() == null) {
                this.max_feature_offsets[i4] = 0;
            } else {
                int[] these_offsets = this.feature_extractors[i4].getDepenedencyOffsets();
                this.max_feature_offsets[i4] = Math.abs(these_offsets[0] + this.max_feature_offsets[this.feature_extractor_dependencies[i4][0]]);
                int k = 0;
                while (k < these_offsets.length) {
                    int val = Math.abs(these_offsets[k]) + this.max_feature_offsets[this.feature_extractor_dependencies[i4][k]];
                    if (val > this.max_feature_offsets[i4]) {
                        this.max_feature_offsets[i4] = val;
                    }
                    ++k;
                }
            }
            ++i4;
        }
    }

    private double[] preProcessRecording(File recording_file) throws Exception {
        AudioInputStream original_stream = AudioSystem.getAudioInputStream(recording_file);
        AudioFormat original_format = original_stream.getFormat();
        int bit_depth = original_format.getSampleSizeInBits();
        if (bit_depth != 8 && bit_depth != 16) {
            bit_depth = 16;
        }
        AudioInputStream second_stream = original_stream;
        if (original_format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED || !original_format.isBigEndian()) {
            AudioFormat new_format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, original_format.getSampleRate(), bit_depth, original_format.getChannels(), original_format.getChannels() * (bit_depth / 8), original_format.getSampleRate(), true);
            second_stream = AudioSystem.getAudioInputStream(new_format, original_stream);
        }
        AudioInputStream new_stream = second_stream;
        if (original_format.getSampleRate() != (float)this.sampling_rate || bit_depth != original_format.getSampleSizeInBits()) {
            AudioFormat new_format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, (float)this.sampling_rate, bit_depth, original_format.getChannels(), original_format.getChannels() * (bit_depth / 8), original_format.getSampleRate(), true);
            new_stream = AudioSystem.getAudioInputStream(new_format, second_stream);
        }
        AudioSamples audio_data = new AudioSamples(new_stream, recording_file.getPath(), false);
        if (this.normalise) {
            audio_data.normalizeMixedDownSamples();
        }
        return audio_data.getSamplesMixedDown();
    }

    private double[][][] getFeatures(double[] samples, int[] window_start_indices) throws Exception {
        double[][][] results = new double[window_start_indices.length][this.feature_extractors.length][];
        int updateThreshold = 1;
        if (window_start_indices.length > 100) {
            updateThreshold = window_start_indices.length / 100;
        }
        int win = 0;
        while (win < window_start_indices.length) {
            int samp;
            if (this.updater != null && win % updateThreshold == 0) {
                this.updater.announceUpdate(win);
                if (this.cancel.isCancel()) {
                    throw new ExplicitCancel("Killed while processing features");
                }
            }
            double[] window = new double[this.window_size];
            int start_sample = window_start_indices[win];
            int end_sample = start_sample + this.window_size - 1;
            if (end_sample < samples.length) {
                samp = start_sample;
                while (samp <= end_sample) {
                    window[samp - start_sample] = samples[samp];
                    ++samp;
                }
            } else {
                samp = start_sample;
                while (samp <= end_sample) {
                    window[samp - start_sample] = samp < samples.length ? samples[samp] : 0.0;
                    ++samp;
                }
            }
            int feat = 0;
            while (feat < this.feature_extractors.length) {
                if (win >= this.max_feature_offsets[feat]) {
                    FeatureExtractor feature = this.feature_extractors[feat];
                    Object other_feature_values = null;
                    if (this.feature_extractor_dependencies[feat] != null) {
                        other_feature_values = new double[this.feature_extractor_dependencies[feat].length][];
                        int i = 0;
                        while (i < this.feature_extractor_dependencies[feat].length) {
                            int feature_indice = this.feature_extractor_dependencies[feat][i];
                            int offset = feature.getDepenedencyOffsets()[i];
                            other_feature_values[i] = results[win + offset][feature_indice];
                            ++i;
                        }
                    }
                    results[win][feat] = feature.extractFeature(window, this.sampling_rate, (double[][])other_feature_values);
                } else {
                    results[win][feat] = null;
                }
                ++feat;
            }
            ++win;
        }
        return results;
    }

    private double[][] getOverallRecordingFeatures(double[][][] window_feature_values, FeatureDefinition[][] overall_feature_definitions) {
        LinkedList<double[]> values = new LinkedList<double[]>();
        LinkedList<FeatureDefinition> definitions = new LinkedList<FeatureDefinition>();
        int feat = 0;
        while (feat < this.feature_extractors.length) {
            if (window_feature_values[window_feature_values.length - 1][feat] != null && this.features_to_save[feat]) {
                FeatureDefinition this_def = this.feature_extractors[feat].getFeatureDefinition();
                FeatureDefinition average_definition = new FeatureDefinition(String.valueOf(this_def.name) + " Overall Average", String.valueOf(this_def.description) + "\nThis is the overall average over all windows.", this_def.is_sequential, window_feature_values[window_feature_values.length - 1][feat].length);
                FeatureDefinition stdv_definition = new FeatureDefinition(String.valueOf(this_def.name) + " Overall Standard Deviation", String.valueOf(this_def.description) + "\nThis is the overall standard deviation over all windows.", this_def.is_sequential, window_feature_values[window_feature_values.length - 1][feat].length);
                double[] averages = new double[window_feature_values[window_feature_values.length - 1][feat].length];
                double[] stdvs = new double[window_feature_values[window_feature_values.length - 1][feat].length];
                int val = 0;
                while (val < window_feature_values[window_feature_values.length - 1][feat].length) {
                    int count = 0;
                    int win = 0;
                    while (win < window_feature_values.length) {
                        if (window_feature_values[win][feat] != null) {
                            ++count;
                        }
                        ++win;
                    }
                    double[] values_to_process = new double[count];
                    int current = 0;
                    int win2 = 0;
                    while (win2 < window_feature_values.length) {
                        if (window_feature_values[win2][feat] != null) {
                            values_to_process[current] = window_feature_values[win2][feat][val];
                            ++current;
                        }
                        ++win2;
                    }
                    averages[val] = Statistics.getAverage(values_to_process);
                    stdvs[val] = Statistics.getStandardDeviation(values_to_process);
                    ++val;
                }
                values.add(averages);
                definitions.add(average_definition);
                values.add(stdvs);
                definitions.add(stdv_definition);
            }
            ++feat;
        }
        overall_feature_definitions[0] = definitions.toArray(new FeatureDefinition[1]);
        return (double[][])values.toArray((T[])new double[1][]);
    }

    private void writeValuesXMLHeader() throws Exception {
        String feature_vector_header = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE feature_vector_file [\n   <!ELEMENT feature_vector_file (comments, data_set+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT data_set (data_set_id, section*, feature*)>\n   <!ELEMENT data_set_id (#PCDATA)>\n   <!ELEMENT section (feature+)>\n   <!ATTLIST section start CDATA \"\"\n                     stop CDATA \"\">\n   <!ELEMENT feature (name, v+)>\n   <!ELEMENT name (#PCDATA)>\n   <!ELEMENT v (#PCDATA)>\n]>\n\n<feature_vector_file>\n\n   <comments></comments>\n\n");
        this.values_writer.writeBytes(feature_vector_header);
    }

    private void writeValuesARFFHeader() throws Exception {
        String sep = System.getProperty("line.separator");
        String feature_value_header = "@relation jAudio" + sep;
        this.values_writer.writeBytes(feature_value_header);
        if (this.save_features_for_each_window && !this.save_overall_recording_features) {
            int i = 0;
            while (i < this.feature_extractors.length) {
                if (this.features_to_save[i]) {
                    String name = this.feature_extractors[i].getFeatureDefinition().name;
                    int dimension = this.feature_extractors[i].getFeatureDefinition().dimensions;
                    int j = 0;
                    while (j < dimension) {
                        this.values_writer.writeBytes("@ATTRIBUTE \"" + name + j + "\" NUMERIC" + sep);
                        ++j;
                    }
                }
                ++i;
            }
            this.values_writer.writeBytes(sep);
            this.values_writer.writeBytes("@DATA" + sep);
        }
    }

    private void saveARFFFeatureVectorsForARecording(double[][][] feature_values, int[] window_start_indices, String identifier, AggregatorContainer aggContainer) throws Exception {
        if (this.save_overall_recording_features) {
            if (!this.isARFFOverallHeaderWritten) {
                aggContainer.outputARFFHeaderEntries(this.values_writer);
                this.isARFFOverallHeaderWritten = true;
            }
            aggContainer.outputARFFValueEntries(this.values_writer);
        } else {
            int win = 0;
            while (win < feature_values.length) {
                int feat = 0;
                while (feat < feature_values[win].length) {
                    if (this.features_to_save[feat]) {
                        if (feature_values[win][feat] == null) {
                            int dim = this.feature_extractors[feat].getFeatureDefinition().dimensions;
                            int d = 0;
                            while (d < dim) {
                                this.values_writer.writeBytes("?");
                                if (d < dim - 1) {
                                    this.values_writer.writeBytes(",");
                                }
                                ++d;
                            }
                        } else {
                            int d = 0;
                            while (d < feature_values[win][feat].length) {
                                String value = StringMethods.getDoubleInScientificNotation(feature_values[win][feat][d], 4);
                                this.values_writer.writeBytes(value);
                                if (d < feature_values[win][feat].length - 1) {
                                    this.values_writer.writeBytes(",");
                                }
                                ++d;
                            }
                        }
                        if (feat < feature_values[win].length - 1) {
                            this.values_writer.writeBytes(",");
                        }
                    }
                    ++feat;
                }
                this.values_writer.writeBytes(System.getProperty("line.separator"));
                ++win;
            }
        }
    }

    private void saveACEFeatureVectorsForARecording(double[][][] feature_values, int[] window_start_indices, String identifier, AggregatorContainer aggContainer) throws Exception {
        this.values_writer.writeBytes("\t<data_set>\n");
        this.values_writer.writeBytes("\t\t<data_set_id>" + identifier + "</data_set_id>\n");
        if (this.save_features_for_each_window) {
            int win = 0;
            while (win < feature_values.length) {
                double start_time = (double)window_start_indices[win] / this.sampling_rate;
                double end_time = (double)(window_start_indices[win] + this.window_size - 1) / this.sampling_rate;
                this.values_writer.writeBytes("\t\t<section start=\"" + start_time + "\" stop=\"" + end_time + "\">\n");
                int feat = 0;
                while (feat < feature_values[win].length) {
                    if (this.features_to_save[feat] && feature_values[win][feat] != null) {
                        String feature_name = this.feature_extractors[feat].getFeatureDefinition().name;
                        this.values_writer.writeBytes("\t\t\t<feature>\n");
                        this.values_writer.writeBytes("\t\t\t\t<name>" + feature_name + "</name>\n");
                        int val = 0;
                        while (val < feature_values[win][feat].length) {
                            String value = StringMethods.getDoubleInScientificNotation(feature_values[win][feat][val], 4);
                            this.values_writer.writeBytes("\t\t\t\t<v>" + value + "</v>\n");
                            ++val;
                        }
                        this.values_writer.writeBytes("\t\t\t</feature>\n");
                    }
                    ++feat;
                }
                this.values_writer.writeBytes("\t\t</section>\n");
                ++win;
            }
        }
        if (this.save_overall_recording_features) {
            aggContainer.outputACEValueEntries(this.values_writer);
        }
        this.values_writer.writeBytes("\t</data_set>\n\n");
    }

    private void saveFeatureDefinitions(double[][][] feature_values, AggregatorContainer aggContainer) throws Exception {
        String feature_key_header = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE feature_key_file [\n   <!ELEMENT feature_key_file (comments, feature+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT feature (name, description?, is_sequential, parallel_dimensions)>\n   <!ELEMENT name (#PCDATA)>\n   <!ELEMENT description (#PCDATA)>\n   <!ELEMENT is_sequential (#PCDATA)>\n   <!ELEMENT parallel_dimensions (#PCDATA)>\n]>\n\n<feature_key_file>\n\n   <comments></comments>\n\n");
        this.definitions_writer.writeBytes(feature_key_header);
        double[][] last_window_features = feature_values[feature_values.length - 1];
        if (this.save_features_for_each_window) {
            int feat = 0;
            while (feat < this.feature_extractors.length) {
                if (this.features_to_save[feat] && last_window_features[feat] != null) {
                    FeatureDefinition def = this.feature_extractors[feat].getFeatureDefinition();
                    this.definitions_writer.writeBytes("   <feature>\n");
                    this.definitions_writer.writeBytes("      <name>" + def.name + "</name>\n");
                    this.definitions_writer.writeBytes("      <description>" + def.description + "</description>\n");
                    this.definitions_writer.writeBytes("      <is_sequential>" + def.is_sequential + "</is_sequential>\n");
                    this.definitions_writer.writeBytes("      <parallel_dimensions>" + last_window_features[feat].length + "</parallel_dimensions>\n");
                    this.definitions_writer.writeBytes("   </feature>\n\n");
                }
                ++feat;
            }
        }
        if (this.save_overall_recording_features) {
            aggContainer.outputACEFeatureKeyEntries(this.definitions_writer);
        }
        this.definitions_writer.writeBytes("</feature_key_file>");
        this.definitions_writer.close();
        this.definitions_written = true;
    }
}

