/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import jAudioFeatureExtractor.GeneralTools.Statistics;

public class FFT {
    private double[] real_output;
    private double[] imaginary_output;
    private double[] output_angle;
    private double[] output_magnitude;
    private double[] output_power;

    public FFT(double[] real_input, double[] imaginary_input, boolean inverse_transform, boolean use_hanning_window) throws Exception {
        if (imaginary_input != null && real_input.length != imaginary_input.length) {
            throw new Exception("Imaginary and real inputs are of different sizes.");
        }
        if (real_input.length < 3) {
            throw new Exception("Only " + real_input.length + " samples provided.\n" + "At least three are needed.");
        }
        int valid_size = Statistics.ensureIsPowerOfN(real_input.length, 2);
        if (valid_size != real_input.length) {
            double[] temp = new double[valid_size];
            int i = 0;
            while (i < real_input.length) {
                temp[i] = real_input[i];
                ++i;
            }
            i = real_input.length;
            while (i < valid_size) {
                temp[i] = 0.0;
                ++i;
            }
            real_input = temp;
            if (imaginary_input == null) {
                imaginary_input = new double[valid_size];
                i = 0;
                while (i < imaginary_input.length) {
                    imaginary_input[i] = 0.0;
                    ++i;
                }
            } else {
                temp = new double[valid_size];
                i = 0;
                while (i < imaginary_input.length) {
                    temp[i] = imaginary_input[i];
                    ++i;
                }
                i = imaginary_input.length;
                while (i < valid_size) {
                    temp[i] = 0.0;
                    ++i;
                }
                imaginary_input = temp;
            }
        } else if (imaginary_input == null) {
            imaginary_input = new double[valid_size];
            int i = 0;
            while (i < imaginary_input.length) {
                imaginary_input[i] = 0.0;
                ++i;
            }
        }
        this.real_output = new double[valid_size];
        System.arraycopy(real_input, 0, this.real_output, 0, valid_size);
        this.imaginary_output = new double[valid_size];
        System.arraycopy(imaginary_input, 0, this.imaginary_output, 0, valid_size);
        if (use_hanning_window) {
            int i = 0;
            while (i < this.real_output.length) {
                double hanning = 0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)valid_size);
                int n = i++;
                this.real_output[n] = this.real_output[n] * hanning;
            }
        }
        int forward_transform = 1;
        if (inverse_transform) {
            forward_transform = -1;
        }
        double scale = 1.0;
        int j = 0;
        int i = 0;
        while (i < valid_size) {
            if (j >= i) {
                double tempr = this.real_output[j] * scale;
                double tempi = this.imaginary_output[j] * scale;
                this.real_output[j] = this.real_output[i] * scale;
                this.imaginary_output[j] = this.imaginary_output[i] * scale;
                this.real_output[i] = tempr;
                this.imaginary_output[i] = tempi;
            }
            int m = valid_size / 2;
            while (m >= 1 && j >= m) {
                j -= m;
                m /= 2;
            }
            j += m;
            ++i;
        }
        boolean stage = false;
        int max_spectra_for_stage = 1;
        int step_size = 2 * max_spectra_for_stage;
        while (max_spectra_for_stage < valid_size) {
            double delta_angle = (double)forward_transform * Math.PI / (double)max_spectra_for_stage;
            int spectra_count = 0;
            while (spectra_count < max_spectra_for_stage) {
                double angle = (double)spectra_count * delta_angle;
                double real_correction = Math.cos(angle);
                double imag_correction = Math.sin(angle);
                int right = 0;
                int left = spectra_count;
                while (left < valid_size) {
                    right = left + max_spectra_for_stage;
                    double temp_real = real_correction * this.real_output[right] - imag_correction * this.imaginary_output[right];
                    double temp_imag = real_correction * this.imaginary_output[right] + imag_correction * this.real_output[right];
                    this.real_output[right] = this.real_output[left] - temp_real;
                    this.imaginary_output[right] = this.imaginary_output[left] - temp_imag;
                    int n = left;
                    this.real_output[n] = this.real_output[n] + temp_real;
                    int n2 = left;
                    this.imaginary_output[n2] = this.imaginary_output[n2] + temp_imag;
                    left += step_size;
                }
                ++spectra_count;
            }
            max_spectra_for_stage = step_size;
            max_spectra_for_stage = step_size;
            step_size = 2 * max_spectra_for_stage;
        }
        this.output_angle = null;
        this.output_power = null;
        this.output_magnitude = null;
    }

    public double[] getMagnitudeSpectrum() {
        if (this.output_magnitude == null) {
            int number_unfolded_bins = this.imaginary_output.length / 2;
            this.output_magnitude = new double[number_unfolded_bins];
            int i = 0;
            while (i < this.output_magnitude.length) {
                this.output_magnitude[i] = Math.sqrt(this.real_output[i] * this.real_output[i] + this.imaginary_output[i] * this.imaginary_output[i]) / (double)this.real_output.length;
                ++i;
            }
        }
        return this.output_magnitude;
    }

    public double[] getPowerSpectrum() {
        if (this.output_power == null) {
            int number_unfolded_bins = this.imaginary_output.length / 2;
            this.output_power = new double[number_unfolded_bins];
            int i = 0;
            while (i < this.output_power.length) {
                this.output_power[i] = (this.real_output[i] * this.real_output[i] + this.imaginary_output[i] * this.imaginary_output[i]) / (double)this.real_output.length;
                ++i;
            }
        }
        return this.output_power;
    }

    public double[] getPhaseAngles() {
        if (this.output_angle == null) {
            int number_unfolded_bins = this.imaginary_output.length / 2;
            this.output_angle = new double[number_unfolded_bins];
            int i = 0;
            while (i < this.output_angle.length) {
                this.output_angle[i] = this.imaginary_output[i] == 0.0 && this.real_output[i] == 0.0 ? 0.0 : Math.atan(this.imaginary_output[i] / this.real_output[i]) * 180.0 / Math.PI;
                if (this.real_output[i] < 0.0 && this.imaginary_output[i] == 0.0) {
                    this.output_angle[i] = 180.0;
                } else if (this.real_output[i] < 0.0 && this.imaginary_output[i] == -0.0) {
                    this.output_angle[i] = -180.0;
                } else if (this.real_output[i] < 0.0 && this.imaginary_output[i] > 0.0) {
                    int n = i;
                    this.output_angle[n] = this.output_angle[n] + 180.0;
                } else if (this.real_output[i] < 0.0 && this.imaginary_output[i] < 0.0) {
                    int n = i;
                    this.output_angle[n] = this.output_angle[n] + -180.0;
                }
                ++i;
            }
        }
        return this.output_angle;
    }

    public double[] getBinLabels(double sampling_rate) {
        int number_bins = this.real_output.length;
        double bin_width = sampling_rate / (double)number_bins;
        int number_unfolded_bins = this.imaginary_output.length / 2;
        double[] labels = new double[number_unfolded_bins];
        labels[0] = 0.0;
        int bin = 1;
        while (bin < labels.length) {
            labels[bin] = (double)bin * bin_width;
            ++bin;
        }
        return labels;
    }

    public double[] getRealValues() {
        return this.real_output;
    }

    public double[] getImaginaryValues() {
        return this.imaginary_output;
    }
}

