/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.AudioSamples;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class PlaySamplesAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private Controller controller;
    private JTable recordings_table;

    public PlaySamplesAction(Controller c) {
        super("Play Samples...");
        this.controller = c;
    }

    public void setTable(JTable rt) {
        this.recordings_table = rt;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            int selected_row = this.recordings_table.getSelectedRow();
            if (selected_row < 0) {
                throw new Exception("No file selcected for playback.");
            }
            RecordingInfo selected_audio = this.controller.dm_.recordingInfo[selected_row];
            try {
                AudioInputStream audio_input_stream = null;
                if (selected_audio.samples != null) {
                    audio_input_stream = selected_audio.samples.getAudioInputStreamChannelSegregated();
                } else {
                    File load_file = new File(selected_audio.file_path);
                    AudioSamples samples = new AudioSamples(load_file, load_file.getPath(), false);
                    if (this.controller.storeSamples.isSelected()) {
                        selected_audio.samples = samples;
                    }
                    audio_input_stream = samples.getAudioInputStreamChannelSegregated();
                }
                SourceDataLine source_data_line = AudioMethods.getSourceDataLine(audio_input_stream.getFormat(), null);
                this.controller.stopPlayBackAction.stopPlayback();
                this.controller.dm_.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audio_input_stream, source_data_line);
            }
            catch (UnsupportedAudioFileException ex) {
                throw new Exception("File " + selected_audio.file_path + " has an unsupported audio format.");
            }
            catch (Exception ex) {
                throw new Exception("File " + selected_audio.file_path + " is not playable.\n" + ex.getMessage());
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
        }
    }
}

